/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.nio.NioHttpChannel;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.nio.NioTcpChannel;
import org.elasticsearch.xpack.security.transport.nio.SSLChannelContext;

public class SSLEngineUtils {
    private SSLEngineUtils() {
    }

    public static void extractClientCertificates(Logger logger, ThreadContext threadContext, Channel channel) {
        SSLEngine sslEngine = SSLEngineUtils.getSSLEngine(channel);
        SSLEngineUtils.extract(logger, threadContext, sslEngine, channel);
    }

    public static void extractClientCertificates(Logger logger, ThreadContext threadContext, HttpChannel channel) {
        SSLEngine sslEngine = SSLEngineUtils.getSSLEngine(channel);
        SSLEngineUtils.extract(logger, threadContext, sslEngine, channel);
    }

    public static void extractClientCertificates(Logger logger, ThreadContext threadContext, TcpChannel tcpChannel) {
        SSLEngine sslEngine = SSLEngineUtils.getSSLEngine(tcpChannel);
        SSLEngineUtils.extract(logger, threadContext, sslEngine, tcpChannel);
    }

    public static SSLEngine getSSLEngine(HttpChannel httpChannel) {
        if (httpChannel instanceof Netty4HttpChannel) {
            Channel nettyChannel = ((Netty4HttpChannel)httpChannel).getNettyChannel();
            return SSLEngineUtils.getSSLEngine(nettyChannel);
        }
        if (httpChannel instanceof NioHttpChannel) {
            SocketChannelContext context = ((NioHttpChannel)httpChannel).getContext();
            assert (context instanceof SSLChannelContext) : "Must be SSLChannelContext.class, found:  " + context.getClass();
            return ((SSLChannelContext)context).getSSLEngine();
        }
        throw new AssertionError((Object)("Unknown channel class type: " + httpChannel.getClass()));
    }

    public static SSLEngine getSSLEngine(Channel channel) {
        SslHandler handler = (SslHandler)channel.pipeline().get(SslHandler.class);
        assert (handler != null) : "Must have SslHandler";
        return handler.engine();
    }

    public static SSLEngine getSSLEngine(TcpChannel tcpChannel) {
        if (tcpChannel instanceof Netty4TcpChannel) {
            Channel nettyChannel = ((Netty4TcpChannel)tcpChannel).getNettyChannel();
            SslHandler handler = (SslHandler)nettyChannel.pipeline().get(SslHandler.class);
            if (handler == null) {
                if (nettyChannel.isOpen()) {
                    assert (false) : "Must have SslHandler";
                } else {
                    throw new ChannelException("Channel is closed.");
                }
            }
            return handler.engine();
        }
        if (tcpChannel instanceof NioTcpChannel) {
            SocketChannelContext context = ((NioTcpChannel)tcpChannel).getContext();
            assert (context instanceof SSLChannelContext) : "Must be SSLChannelContext.class, found:  " + context.getClass();
            return ((SSLChannelContext)context).getSSLEngine();
        }
        throw new AssertionError((Object)("Unknown channel class type: " + tcpChannel.getClass()));
    }

    private static void extract(Logger logger, ThreadContext threadContext, SSLEngine sslEngine, Object channel) {
        block6: {
            try {
                Certificate[] certs = sslEngine.getSession().getPeerCertificates();
                if (certs instanceof X509Certificate[]) {
                    threadContext.putTransient("__SECURITY_CLIENT_CERTIFICATE", (Object)certs);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                assert (!sslEngine.getNeedClientAuth());
                assert (sslEngine.getWantClientAuth());
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("SSL Peer did not present a certificate on channel [{}]", channel), (Throwable)e);
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("SSL Peer did not present a certificate on channel [{}]", channel);
            }
        }
    }
}

