/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;

public class SecondaryAuthenticator {
    public static final String SECONDARY_AUTH_HEADER_NAME = "es-secondary-authorization";
    private final Logger logger = LogManager.getLogger();
    private final SecurityContext securityContext;
    private final AuthenticationService authenticationService;
    private final AuditTrailService auditTrailService;

    public SecondaryAuthenticator(Settings settings, ThreadContext threadContext, AuthenticationService authenticationService, AuditTrailService auditTrailService) {
        this(new SecurityContext(settings, threadContext), authenticationService, auditTrailService);
    }

    public SecondaryAuthenticator(SecurityContext securityContext, AuthenticationService authenticationService, AuditTrailService auditTrailService) {
        this.securityContext = securityContext;
        this.authenticationService = authenticationService;
        this.auditTrailService = auditTrailService;
    }

    public void authenticate(String action, TransportRequest request, ActionListener<SecondaryAuthentication> listener) {
        this.authenticate(authListener -> this.authenticationService.authenticate(action, request, false, (ActionListener<Authentication>)authListener), listener);
    }

    public void authenticateAndAttachToContext(RestRequest request, ActionListener<SecondaryAuthentication> listener) {
        ThreadContext threadContext = this.securityContext.getThreadContext();
        this.authenticate(authListener -> this.authenticationService.authenticate((HttpPreRequest)request.getHttpRequest(), false, (ActionListener<Authentication>)authListener.delegateFailure((l, authentication) -> {
            this.auditTrailService.get().authenticationSuccess(request);
            l.onResponse(authentication);
        })), (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
            if (secondaryAuthentication != null) {
                secondaryAuthentication.writeToContext(threadContext);
            }
            listener.onResponse(secondaryAuthentication);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void authenticate(Consumer<ActionListener<Authentication>> authenticate, ActionListener<SecondaryAuthentication> listener) {
        ThreadContext threadContext = this.securityContext.getThreadContext();
        String header = threadContext.getHeader(SECONDARY_AUTH_HEADER_NAME);
        if (Strings.isNullOrEmpty((String)header)) {
            this.logger.trace("no secondary authentication credentials found (the [{}] header is [{}])", (Object)SECONDARY_AUTH_HEADER_NAME, (Object)header);
            listener.onResponse(null);
            return;
        }
        Supplier originalContext = threadContext.newRestorableContext(false);
        ContextPreservingActionListener authenticationListener = new ContextPreservingActionListener(originalContext, ActionListener.wrap(authentication -> {
            if (authentication == null) {
                this.logger.debug("secondary authentication failed - authentication service returned a null authentication object");
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Failed to authenticate secondary user", new Object[0])));
            } else {
                this.logger.debug("secondary authentication succeeded [{}]", authentication);
                listener.onResponse((Object)new SecondaryAuthentication(this.securityContext, authentication));
            }
        }, e -> {
            this.logger.debug("secondary authentication failed - authentication service responded with failure", (Throwable)e);
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Failed to authenticate secondary user", e, new Object[0])));
        }));
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.logger.trace("found secondary authentication credentials, placing them in the internal [{}] header for authentication", (Object)"Authorization");
            threadContext.putHeader("Authorization", header);
            authenticate.accept((ActionListener<Authentication>)authenticationListener);
        }
    }
}

