/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.job;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.CRC32;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.hash.MurmurHash3;

public abstract class RollupIDGenerator {
    private boolean generated = false;

    public abstract void add(Integer var1);

    public abstract void add(Long var1);

    public abstract void add(Double var1);

    public abstract void add(String var1);

    public abstract void addNull();

    public abstract String getID();

    final boolean check(Object v) {
        if (this.generated) {
            throw new RuntimeException("Cannot update ID as it has already been generated.");
        }
        if (v == null) {
            this.addNull();
            return false;
        }
        return true;
    }

    final void setFlag() {
        if (this.generated) {
            throw new RuntimeException("Cannot generate ID as it has already been generated.");
        }
        this.generated = true;
    }

    public static class Murmur3
    extends RollupIDGenerator {
        private static final long SEED = 19L;
        private static final BytesRef DELIM = new BytesRef((CharSequence)"$");
        private static final BytesRef NULL_PLACEHOLDER = new BytesRef((CharSequence)"__NULL_PLACEHOLDER__830f1de2__");
        private final BytesRefBuilder id = new BytesRefBuilder();
        private final String jobId;

        Murmur3(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public void add(Integer v) {
            if (this.check(v)) {
                this.update(Numbers.intToBytes((int)v));
            }
        }

        @Override
        public void add(Long v) {
            if (this.check(v)) {
                this.update(Numbers.longToBytes((long)v));
            }
        }

        @Override
        public void add(Double v) {
            if (this.check(v)) {
                this.update(Numbers.doubleToBytes((double)v));
            }
        }

        @Override
        public void add(String v) {
            if (this.check(v)) {
                this.update(v.getBytes(StandardCharsets.UTF_8));
            }
        }

        @Override
        public void addNull() {
            this.update(Murmur3.NULL_PLACEHOLDER.bytes);
        }

        private void update(byte[] v) {
            this.id.append(v, 0, v.length);
            this.id.append(DELIM);
        }

        @Override
        public String getID() {
            this.setFlag();
            MurmurHash3.Hash128 hasher = MurmurHash3.hash128((byte[])this.id.bytes(), (int)0, (int)this.id.length(), (long)19L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
            byte[] hashedBytes = new byte[16];
            System.arraycopy(Numbers.longToBytes((long)hasher.h1), 0, hashedBytes, 0, 8);
            System.arraycopy(Numbers.longToBytes((long)hasher.h2), 0, hashedBytes, 8, 8);
            return this.jobId + "$" + Base64.getUrlEncoder().withoutPadding().encodeToString(hashedBytes);
        }
    }

    @Deprecated
    public static class CRC
    extends RollupIDGenerator {
        private final CRC32 crc = new CRC32();

        @Override
        public void add(Integer v) {
            if (this.check(v)) {
                this.crc.update(v);
            }
        }

        @Override
        public void add(Long v) {
            if (this.check(v)) {
                this.crc.update(Numbers.longToBytes((long)v), 0, 8);
            }
        }

        @Override
        public void add(Double v) {
            if (this.check(v)) {
                this.crc.update(Numbers.doubleToBytes((double)v), 0, 8);
            }
        }

        @Override
        public void add(String v) {
            if (this.check(v)) {
                byte[] vs = v.getBytes(StandardCharsets.UTF_8);
                this.crc.update(vs, 0, vs.length);
            }
        }

        @Override
        public void addNull() {
            this.crc.update(19);
        }

        @Override
        public String getID() {
            this.setFlag();
            return String.valueOf(this.crc.getValue());
        }
    }
}

