/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.datastreams;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.datastreams.DataStreamFeatureSetUsage;

public class DataStreamFeatureSet
implements XPackFeatureSet {
    private final ClusterService clusterService;

    @Inject
    public DataStreamFeatureSet(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public String name() {
        return "data_streams";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        Map dataStreams = state.metadata().dataStreams();
        DataStreamFeatureSetUsage.DataStreamStats stats = new DataStreamFeatureSetUsage.DataStreamStats((long)dataStreams.size(), (long)dataStreams.values().stream().map(ds -> ds.getIndices().size()).reduce(Integer::sum).orElse(0).intValue());
        DataStreamFeatureSetUsage usage = new DataStreamFeatureSetUsage(stats);
        listener.onResponse((Object)usage);
    }
}

