/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.compat.UpdateTransformActionPre78;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;

public class UpdateTransformAction
extends ActionType<Response> {
    public static final UpdateTransformAction INSTANCE = new UpdateTransformAction();
    public static final String NAME = "cluster:admin/transform/update";
    private static final TimeValue MIN_FREQUENCY = TimeValue.timeValueSeconds((long)1L);
    private static final TimeValue MAX_FREQUENCY = TimeValue.timeValueHours((long)1L);

    private UpdateTransformAction() {
        super(NAME, x$0 -> new Response(x$0));
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private final TransformConfig config;

        public Response(TransformConfig config) {
            super(Collections.emptyList(), Collections.emptyList());
            this.config = config;
        }

        private Response(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
        }

        public static Response fromStreamWithBWC(StreamInput in) throws IOException {
            if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
                return new Response(in);
            }
            UpdateTransformActionPre78.Response r = new UpdateTransformActionPre78.Response(in);
            return new Response(r.getConfig());
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                super.writeTo(out);
                this.config.writeTo(out);
                return;
            }
            UpdateTransformActionPre78.Response r = new UpdateTransformActionPre78.Response(this.config);
            r.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.config});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config) && super.equals(obj);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.toXContentCommon(builder, params);
            return this.config.toXContent(builder, params);
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final TransformConfigUpdate update;
        private final String id;
        private final boolean deferValidation;
        private TransformConfig config;

        public Request(TransformConfigUpdate update, String id, boolean deferValidation, TimeValue timeout) {
            this.update = update;
            this.id = id;
            this.deferValidation = deferValidation;
            this.setTimeout(timeout);
        }

        private Request(StreamInput in) throws IOException {
            super(in);
            this.update = new TransformConfigUpdate(in);
            this.id = in.readString();
            this.deferValidation = in.readBoolean();
            if (in.readBoolean()) {
                this.config = new TransformConfig(in);
            }
        }

        public static Request fromStreamWithBWC(StreamInput in) throws IOException {
            if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
                return new Request(in);
            }
            UpdateTransformActionPre78.Request r = new UpdateTransformActionPre78.Request(in);
            return new Request(r.getUpdate(), r.getId(), r.isDeferValidation(), r.timeout());
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation, TimeValue timeout) {
            return new Request(TransformConfigUpdate.fromXContent(parser), id, deferValidation, timeout);
        }

        public ActionRequestValidationException validate() {
            TimeValue frequency;
            ActionRequestValidationException validationException = null;
            if (this.update.getDestination() != null && this.update.getDestination().getIndex() != null) {
                validationException = SourceDestValidator.validateRequest(validationException, this.update.getDestination().getIndex());
            }
            if ((frequency = this.update.getFrequency()) != null) {
                if (frequency.compareTo(MIN_FREQUENCY) < 0) {
                    validationException = ValidateActions.addValidationError((String)("minimum permitted [" + TransformField.FREQUENCY + "] is [" + MIN_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                } else if (frequency.compareTo(MAX_FREQUENCY) > 0) {
                    validationException = ValidateActions.addValidationError((String)("highest permitted [" + TransformField.FREQUENCY + "] is [" + MAX_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public TransformConfigUpdate getUpdate() {
            return this.update;
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void setConfig(TransformConfig config) {
            this.config = config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
                super.writeTo(out);
                this.update.writeTo(out);
                out.writeString(this.id);
                out.writeBoolean(this.deferValidation);
                if (this.config == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    this.config.writeTo(out);
                }
                return;
            }
            UpdateTransformActionPre78.Request r = new UpdateTransformActionPre78.Request(this.update, this.id, this.deferValidation);
            r.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getTimeout(), this.update, this.id, this.deferValidation, this.config});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.update, other.update) && this.deferValidation == other.deferValidation && this.id.equals(other.id) && Objects.equals((Object)this.config, (Object)other.config) && this.getTimeout().equals((Object)other.getTimeout());
        }

        public boolean match(Task task) {
            if (task.getDescription().startsWith("data_frame_")) {
                String taskId = task.getDescription().substring("data_frame_".length());
                return taskId.equals(this.id);
            }
            return false;
        }
    }
}

