/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class NodeAcknowledgedResponse
extends AcknowledgedResponse {
    public static final String NODE_FIELD = "node";
    private final String node;

    public NodeAcknowledgedResponse(boolean acknowledged, String node) {
        super(acknowledged);
        this.node = Objects.requireNonNull(node);
    }

    public NodeAcknowledgedResponse(StreamInput in) throws IOException {
        super(in);
        this.node = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readString() : "";
    }

    public String getNode() {
        return this.node;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeString(this.node);
        }
    }

    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NODE_FIELD, this.node);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NodeAcknowledgedResponse that = (NodeAcknowledgedResponse)((Object)o);
        return this.isAcknowledged() == that.isAcknowledged() && Objects.equals(this.node, that.node);
    }

    public int hashCode() {
        return Objects.hash(this.isAcknowledged(), this.node);
    }
}

