/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class PostStartTrialRequest
extends MasterNodeRequest<PostStartTrialRequest> {
    private boolean acknowledge = false;
    private String type;

    public PostStartTrialRequest() {
    }

    public PostStartTrialRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.type = in.readString();
            this.acknowledge = in.readBoolean();
        } else {
            this.type = "trial";
            this.acknowledge = true;
        }
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public PostStartTrialRequest setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public PostStartTrialRequest acknowledge(boolean acknowledge) {
        this.acknowledge = acknowledge;
        return this;
    }

    public boolean isAcknowledged() {
        return this.acknowledge;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version version = Version.V_6_3_0;
        if (out.getVersion().onOrAfter(version)) {
            super.writeTo(out);
            out.writeString(this.type);
            out.writeBoolean(this.acknowledge);
        } else {
            if (!"trial".equals(this.type)) {
                throw new IllegalArgumentException("All nodes in cluster must be version [" + version + "] or newer to start trial with a different type than 'trial'. Attempting to write to a node with version [" + out.getVersion() + "] with trial type [" + this.type + "].");
            }
            if (!this.acknowledge) {
                throw new IllegalArgumentException("Request must be acknowledged to send to a node with a version prior to [" + version + "]. Attempting to send request to node with version [" + out.getVersion() + "] without acknowledgement.");
            }
            super.writeTo(out);
        }
    }
}

