/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.DestinationIndex;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.dataframe.inference.InferenceRunner;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.steps.AnalysisStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.FinalStep;
import org.elasticsearch.xpack.ml.dataframe.steps.InferenceStep;
import org.elasticsearch.xpack.ml.dataframe.steps.ReindexingStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class DataFrameAnalyticsManager {
    private static final Logger LOGGER = LogManager.getLogger(DataFrameAnalyticsManager.class);
    private final Settings settings;
    private final NodeClient client;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final AnalyticsProcessManager processManager;
    private final DataFrameAnalyticsAuditor auditor;
    private final IndexNameExpressionResolver expressionResolver;
    private final ResultsPersisterService resultsPersisterService;
    private final ModelLoadingService modelLoadingService;
    private final AtomicBoolean nodeShuttingDown = new AtomicBoolean();

    public DataFrameAnalyticsManager(Settings settings, NodeClient client, ThreadPool threadPool, ClusterService clusterService, DataFrameAnalyticsConfigProvider configProvider, AnalyticsProcessManager processManager, DataFrameAnalyticsAuditor auditor, IndexNameExpressionResolver expressionResolver, ResultsPersisterService resultsPersisterService, ModelLoadingService modelLoadingService) {
        this.settings = Objects.requireNonNull(settings);
        this.client = Objects.requireNonNull(client);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.processManager = Objects.requireNonNull(processManager);
        this.auditor = Objects.requireNonNull(auditor);
        this.expressionResolver = Objects.requireNonNull(expressionResolver);
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.modelLoadingService = Objects.requireNonNull(modelLoadingService);
    }

    public void execute(DataFrameAnalyticsTask task, ClusterState clusterState, TimeValue masterNodeTimeout) {
        ActionListener configListener = ActionListener.wrap(config -> {
            IndexMetadata destIndex = clusterState.getMetadata().index(config.getDest().getIndex());
            if (destIndex != null) {
                MappingMetadata destIndexMapping = clusterState.getMetadata().index(config.getDest().getIndex()).mapping();
                DestinationIndex.Metadata metadata = DestinationIndex.readMetadata(config.getId(), destIndexMapping);
                if (metadata.hasMetadata() && !metadata.isCompatible()) {
                    LOGGER.info("[{}] Destination index was created in version [{}] but minimum supported version is [{}]. Deleting index and starting from scratch.", (Object)config.getId(), (Object)metadata.getVersion(), (Object)DestinationIndex.MIN_COMPATIBLE_VERSION);
                    task.getStatsHolder().resetProgressTracker(config.getAnalysis().getProgressPhases(), config.getAnalysis().supportsInference());
                    this.executeJobInMiddleOfReindexing(task, (DataFrameAnalyticsConfig)config);
                    return;
                }
            }
            task.getStatsHolder().adjustProgressTracker(config.getAnalysis().getProgressPhases(), config.getAnalysis().supportsInference());
            this.determineProgressAndResume(task, (DataFrameAnalyticsConfig)config);
        }, task::setFailed);
        ActionListener statsIndexListener = ActionListener.wrap(aBoolean -> this.configProvider.get(task.getParams().getId(), (ActionListener<DataFrameAnalyticsConfig>)configListener), arg_0 -> ((ActionListener)configListener).onFailure(arg_0));
        ActionListener stateAliasListener = ActionListener.wrap(aBoolean -> this.createStatsIndexAndUpdateMappingsIfNecessary((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), clusterState, masterNodeTimeout, (ActionListener<Boolean>)statsIndexListener), arg_0 -> ((ActionListener)configListener).onFailure(arg_0));
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessaryAndWaitForYellow((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), (ClusterState)clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)masterNodeTimeout, (ActionListener)stateAliasListener);
    }

    private void createStatsIndexAndUpdateMappingsIfNecessary(Client clientToUse, ClusterState clusterState, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ActionListener createIndexListener = ActionListener.wrap(aBoolean -> ElasticsearchMappings.addDocMappingIfMissing((String)MlStatsIndex.writeAlias(), MlStatsIndex::wrappedMapping, (Client)clientToUse, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0));
        MlStatsIndex.createStatsIndexAndAliasIfNecessary((Client)clientToUse, (ClusterState)clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)masterNodeTimeout, (ActionListener)createIndexListener);
    }

    private void determineProgressAndResume(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        DataFrameAnalyticsTask.StartingState startingState = task.determineStartingState();
        LOGGER.debug(() -> new ParameterizedMessage("[{}] Starting job from state [{}]", (Object)config.getId(), (Object)startingState));
        switch (startingState) {
            case FIRST_TIME: {
                this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config));
                break;
            }
            case RESUMING_REINDEXING: {
                this.executeJobInMiddleOfReindexing(task, config);
                break;
            }
            case RESUMING_ANALYZING: {
                this.executeStep(task, config, new AnalysisStep(this.client, task, this.auditor, config, this.processManager));
                break;
            }
            case RESUMING_INFERENCE: {
                this.buildInferenceStep(task, config, (ActionListener<InferenceStep>)ActionListener.wrap(inferenceStep -> this.executeStep(task, config, (DataFrameAnalyticsStep)inferenceStep), task::setFailed));
                break;
            }
            default: {
                task.setFailed((Exception)((Object)ExceptionsHelper.serverError((String)("Unexpected starting state [" + (Object)((Object)startingState) + "]"))));
            }
        }
    }

    private void executeStep(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, DataFrameAnalyticsStep step) {
        task.setStep(step);
        ActionListener stepListener = ActionListener.wrap(stepResponse -> {
            if (stepResponse.isTaskComplete()) {
                this.executeStep(task, config, new FinalStep(this.client, task, this.auditor, config));
                return;
            }
            switch (step.name()) {
                case REINDEXING: {
                    this.executeStep(task, config, new AnalysisStep(this.client, task, this.auditor, config, this.processManager));
                    break;
                }
                case ANALYSIS: {
                    this.buildInferenceStep(task, config, (ActionListener<InferenceStep>)ActionListener.wrap(inferenceStep -> this.executeStep(task, config, (DataFrameAnalyticsStep)inferenceStep), task::setFailed));
                    break;
                }
                case INFERENCE: {
                    this.executeStep(task, config, new FinalStep(this.client, task, this.auditor, config));
                    break;
                }
                case FINAL: {
                    LOGGER.info("[{}] Marking task completed", (Object)config.getId());
                    task.markAsCompleted();
                    break;
                }
                default: {
                    task.markAsFailed((Exception)((Object)ExceptionsHelper.serverError((String)"Unknown step [{}]", (Object[])new Object[]{step})));
                }
            }
        }, task::setFailed);
        step.execute((ActionListener<StepResponse>)stepListener);
    }

    private void executeJobInMiddleOfReindexing(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config) {
        if (task.isStopping()) {
            LOGGER.debug("[{}] task is stopping. Marking as complete before restarting reindexing.", (Object)task.getParams().getId());
            task.markAsCompleted();
            return;
        }
        ClientHelper.executeAsyncWithOrigin((Client)new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId()), (String)"ml", (ActionType)DeleteIndexAction.INSTANCE, (ActionRequest)new DeleteIndexRequest(config.getDest().getIndex()), (ActionListener)ActionListener.wrap(r -> this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config)), e -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                this.executeStep(task, config, new ReindexingStep(this.clusterService, this.client, task, this.auditor, config));
            } else {
                task.setFailed((Exception)e);
            }
        }));
    }

    private void buildInferenceStep(DataFrameAnalyticsTask task, DataFrameAnalyticsConfig config, ActionListener<InferenceStep> listener) {
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient((Client)this.client, task.getParentTaskId());
        ActionListener extractedFieldsDetectorListener = ActionListener.wrap(extractedFieldsDetector -> {
            ExtractedFields extractedFields = (ExtractedFields)extractedFieldsDetector.detect().v1();
            InferenceRunner inferenceRunner = new InferenceRunner(this.settings, (Client)parentTaskClient, this.modelLoadingService, this.resultsPersisterService, task.getParentTaskId(), config, extractedFields, task.getStatsHolder().getProgressTracker(), task.getStatsHolder().getDataCountsTracker());
            InferenceStep inferenceStep = new InferenceStep(this.client, task, this.auditor, config, this.threadPool, inferenceRunner);
            listener.onResponse((Object)inferenceStep);
        }, arg_0 -> listener.onFailure(arg_0));
        new ExtractedFieldsDetectorFactory((Client)parentTaskClient).createFromDest(config, (ActionListener<ExtractedFieldsDetector>)extractedFieldsDetectorListener);
    }

    public boolean isNodeShuttingDown() {
        return this.nodeShuttingDown.get();
    }

    public void markNodeAsShuttingDown() {
        this.nodeShuttingDown.set(true);
    }
}

