/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.ml.job.persistence.CalendarQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetCalendarsAction
extends HandledTransportAction<GetCalendarsAction.Request, GetCalendarsAction.Response> {
    private final JobResultsProvider jobResultsProvider;

    @Inject
    public TransportGetCalendarsAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider) {
        super("cluster:monitor/xpack/ml/calendars/get", transportService, actionFilters, GetCalendarsAction.Request::new);
        this.jobResultsProvider = jobResultsProvider;
    }

    protected void doExecute(Task task, GetCalendarsAction.Request request, ActionListener<GetCalendarsAction.Response> listener) {
        String[] calendarIds = Strings.splitStringByCommaToArray((String)request.getCalendarId());
        PageParams pageParams = request.getPageParams();
        if (pageParams == null) {
            pageParams = PageParams.defaultParams();
        }
        this.getCalendars(calendarIds, pageParams, listener);
    }

    private void getCalendars(String[] idTokens, PageParams pageParams, ActionListener<GetCalendarsAction.Response> listener) {
        CalendarQueryBuilder query = new CalendarQueryBuilder().pageParams(pageParams).calendarIdTokens(idTokens).sort(true);
        this.jobResultsProvider.calendars(query, (ActionListener<QueryPage<Calendar>>)ActionListener.wrap(calendars -> listener.onResponse((Object)new GetCalendarsAction.Response(calendars)), arg_0 -> listener.onFailure(arg_0)));
    }
}

