/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.deprecation.IndexDeprecationChecks;

public class ClusterDeprecationChecks {
    private static final Logger logger = LogManager.getLogger(ClusterDeprecationChecks.class);
    private static final String SPARSE_VECTOR = "sparse_vector";

    static DeprecationIssue checkUserAgentPipelines(ClusterState state) {
        List pipelines = IngestService.getPipelines((ClusterState)state, (String[])new String[0]);
        List pipelinesWithDeprecatedEcsConfig = pipelines.stream().filter(Objects::nonNull).filter(pipeline -> {
            Map pipelineConfig = pipeline.getConfigAsMap();
            List processors = (List)pipelineConfig.get("processors");
            return processors.stream().filter(Objects::nonNull).filter(processor -> processor.containsKey("user_agent")).map(processor -> (Map)processor.get("user_agent")).anyMatch(processorConfig -> processorConfig.containsKey("ecs"));
        }).map(PipelineConfiguration::getId).sorted().collect(Collectors.toList());
        if (!pipelinesWithDeprecatedEcsConfig.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The User-Agent ingest processor's ecs parameter is deprecated", "https://ela.st/es-deprecation-7-ingest-pipeline-ecs-option", "Remove the ecs parameter from your ingest pipelines. The User-Agent ingest processor always returns Elastic Common Schema (ECS) fields in 8.0.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithTooManyFields(ClusterState state) {
        Integer maxClauseCount = (Integer)SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(state.getMetadata().settings());
        ArrayList templatesOverLimit = new ArrayList();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            AtomicInteger maxFields = new AtomicInteger(0);
            String templateName = (String)templateCursor.key;
            boolean defaultFieldSet = ((IndexTemplateMetadata)templateCursor.value).settings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) != null;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                MappingMetadata mappingMetadata = new MappingMetadata((CompressedXContent)mappingCursor.value);
                if (mappingMetadata != null && !defaultFieldSet) {
                    maxFields.set(IndexDeprecationChecks.countFieldsRecursively(mappingMetadata.type(), mappingMetadata.sourceAsMap()));
                }
                if (maxFields.get() > maxClauseCount) {
                    templatesOverLimit.add(templateName);
                }
            });
        });
        if (!templatesOverLimit.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Fields in index template exceed automatic field expansion limit", "https://ela.st/es-deprecation-7-number-of-auto-expanded-fields", "Index templates " + templatesOverLimit + " have a number of fields which exceeds the automatic field expansion limit of [" + maxClauseCount + "] and does not have [" + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithChainedMultiFields(ClusterState state) {
        HashMap templatesContainingChainedMultiFields = new HashMap();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                List<String> mappingIssues;
                String type = (String)mappingCursor.key;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)((CompressedXContent)mappingCursor.value).compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey(type)) {
                    mapping = (Map)mapping.get(type);
                }
                if ((mappingIssues = IndexDeprecationChecks.findInPropertiesRecursively(type, mapping, IndexDeprecationChecks::containsChainedMultiFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingChainedMultiFields.put(templateName, mappingIssues);
                }
            });
        });
        if (!templatesContainingChainedMultiFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields on index template mappings is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" template%s. Multi-fields within multi-fields are not supported in 8.0.", String.join((CharSequence)",", templatesContainingChainedMultiFields.keySet()), templatesContainingChainedMultiFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithChainedMultiFieldsInDynamicTemplates(ClusterState state) {
        HashMap templatesContainingChainedMultiFields = new HashMap();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                List<String> mappingIssues;
                String type = (String)mappingCursor.key;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)((CompressedXContent)mappingCursor.value).compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey(type)) {
                    mapping = (Map)mapping.get(type);
                }
                if ((mappingIssues = IndexDeprecationChecks.findInDynamicTemplates(type, mapping, IndexDeprecationChecks::containsMappingWithChainedMultiFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingChainedMultiFields.put(templateName, mappingIssues);
                }
            });
        });
        if (!templatesContainingChainedMultiFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields on index template dynamic_templates is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" template%s. Multi-fields within multi-fields are not supported in 8.0.", String.join((CharSequence)",", templatesContainingChainedMultiFields.keySet()), templatesContainingChainedMultiFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkComponentTemplatesWithChainedMultiFields(ClusterState state) {
        HashMap templatesContainingChainedMultiFields = new HashMap();
        state.getMetadata().componentTemplates().forEach((templateName, componentTemplate) -> {
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                List<String> mappingIssues;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)mappings.compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey("_doc")) {
                    mapping = (Map)mapping.get("_doc");
                }
                if ((mappingIssues = IndexDeprecationChecks.findInPropertiesRecursively("_doc", mapping, IndexDeprecationChecks::containsChainedMultiFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingChainedMultiFields.put(templateName, mappingIssues);
                }
            }
        });
        if (!templatesContainingChainedMultiFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields on component templates is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" component template%s. Multi-fields within multi-fields are not supported in 8.0.", String.join((CharSequence)",", templatesContainingChainedMultiFields.keySet()), templatesContainingChainedMultiFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkComponentTemplatesWithChainedMultiFieldsInDynamicTemplates(ClusterState state) {
        HashMap templatesContainingChainedMultiFields = new HashMap();
        state.getMetadata().componentTemplates().forEach((templateName, componentTemplate) -> {
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                List<String> mappingIssues;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)mappings.compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey("_doc")) {
                    mapping = (Map)mapping.get("_doc");
                }
                if ((mappingIssues = IndexDeprecationChecks.findInDynamicTemplates("_doc", mapping, IndexDeprecationChecks::containsMappingWithChainedMultiFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingChainedMultiFields.put(templateName, mappingIssues);
                }
            }
        });
        if (!templatesContainingChainedMultiFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining multi-fields within multi-fields on component template dynamic_templates is deprecated", "https://ela.st/es-deprecation-7-chained-multi-fields", String.format(Locale.ROOT, "Remove chained multi-fields from the \"%s\" component template%s. Multi-fields within multi-fields are not supported in 8.0.", String.join((CharSequence)",", templatesContainingChainedMultiFields.keySet()), templatesContainingChainedMultiFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithBoostedFields(ClusterState state) {
        HashMap templatesContainingBoostedFields = new HashMap();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                List<String> mappingIssues;
                String type = (String)mappingCursor.key;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)((CompressedXContent)mappingCursor.value).compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey(type)) {
                    mapping = (Map)mapping.get(type);
                }
                if ((mappingIssues = IndexDeprecationChecks.findInPropertiesRecursively(type, mapping, IndexDeprecationChecks::containsBoostedFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingBoostedFields.put(templateName, mappingIssues);
                }
            });
        });
        if (!templatesContainingBoostedFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining boosted fields on index template mappings is deprecated", "https://ela.st/es-deprecation-7-boost-fields", String.format(Locale.ROOT, "Remove boost fields from the \"%s\" template%s. Configuring a boost value on mapping fields is not supported in 8.0.", String.join((CharSequence)",", templatesContainingBoostedFields.keySet()), templatesContainingBoostedFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithBoostFieldsInDynamicTemplates(ClusterState state) {
        HashMap templatesContainingBoostedFields = new HashMap();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                List<String> mappingIssues;
                String type = (String)mappingCursor.key;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)((CompressedXContent)mappingCursor.value).compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey(type)) {
                    mapping = (Map)mapping.get(type);
                }
                if ((mappingIssues = IndexDeprecationChecks.findInDynamicTemplates(type, mapping, IndexDeprecationChecks::containsMappingWithBoostedFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingBoostedFields.put(templateName, mappingIssues);
                }
            });
        });
        if (!templatesContainingBoostedFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining boosted fields on index template dynamic_templates is deprecated", "https://ela.st/es-deprecation-7-boost-fields", String.format(Locale.ROOT, "Remove boost fields from the \"%s\" template%s. Configuring a boost value on mapping fields is not supported in 8.0.", String.join((CharSequence)",", templatesContainingBoostedFields.keySet()), templatesContainingBoostedFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkComponentTemplatesWithBoostedFields(ClusterState state) {
        HashMap templatesContainingBoostedFields = new HashMap();
        state.getMetadata().componentTemplates().forEach((templateName, componentTemplate) -> {
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                List<String> mappingIssues;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)mappings.compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey("_doc")) {
                    mapping = (Map)mapping.get("_doc");
                }
                if ((mappingIssues = IndexDeprecationChecks.findInPropertiesRecursively("_doc", mapping, IndexDeprecationChecks::containsBoostedFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingBoostedFields.put(templateName, mappingIssues);
                }
            }
        });
        if (!templatesContainingBoostedFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining boosted fields on component templates is deprecated", "https://ela.st/es-deprecation-7-boost-fields", String.format(Locale.ROOT, "Remove boost fields from the \"%s\" component template%s. Configuring a boost value on mapping fields is not supported in 8.0.", String.join((CharSequence)",", templatesContainingBoostedFields.keySet()), templatesContainingBoostedFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkComponentTemplatesWithBoostedFieldsInDynamicTemplates(ClusterState state) {
        HashMap templatesContainingBoostedFields = new HashMap();
        state.getMetadata().componentTemplates().forEach((templateName, componentTemplate) -> {
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                List<String> mappingIssues;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)mappings.compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey("_doc")) {
                    mapping = (Map)mapping.get("_doc");
                }
                if ((mappingIssues = IndexDeprecationChecks.findInDynamicTemplates("_doc", mapping, IndexDeprecationChecks::containsMappingWithBoostedFields, IndexDeprecationChecks::formatField, "", "")).size() > 0) {
                    templatesContainingBoostedFields.put(templateName, mappingIssues);
                }
            }
        });
        if (!templatesContainingBoostedFields.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Defining boosted fields on component template dynamic_templates is deprecated", "https://ela.st/es-deprecation-7-boost-fields", String.format(Locale.ROOT, "Remove boost fields from the \"%s\" component template%s. Configuring a boost value on mapping fields is not supported in 8.0.", String.join((CharSequence)",", templatesContainingBoostedFields.keySet()), templatesContainingBoostedFields.size() > 1 ? "s" : ""), false, null);
        }
        return null;
    }

    static DeprecationIssue checkTemplatesWithFieldNamesDisabled(ClusterState state) {
        HashSet templatesContainingFieldNames = new HashSet();
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ((IndexTemplateMetadata)templateCursor.value).getMappings().forEach(mappingCursor -> {
                String type = (String)mappingCursor.key;
                Map mapping = (Map)XContentHelper.convertToMap((BytesReference)((CompressedXContent)mappingCursor.value).compressedReference(), (boolean)true).v2();
                if (mapping.size() == 1 && mapping.containsKey(type)) {
                    mapping = (Map)mapping.get(type);
                }
                if (ClusterDeprecationChecks.mapContainsFieldNamesDisabled(mapping)) {
                    templatesContainingFieldNames.add(templateName);
                }
            });
        });
        if (!templatesContainingFieldNames.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Disabling the \"_field_names\" field in a template's index mappings is deprecated", "https://ela.st/es-deprecation-7-field_names-settings", String.format(Locale.ROOT, "Remove the \"%s\" mapping that configures the enabled setting from the following templates: \"%s\". There's no longer a need to disable this field to reduce index overhead if you have a lot of fields.", "_field_names", templatesContainingFieldNames.stream().collect(Collectors.joining(","))), false, null);
        }
        return null;
    }

    static boolean mapContainsFieldNamesDisabled(Map<?, ?> map) {
        Object fieldNamesMapping = map.get("_field_names");
        return fieldNamesMapping != null && ((Map)fieldNamesMapping).keySet().contains("enabled");
    }

    static DeprecationIssue checkTemplatesWithCustomAndMultipleTypes(ClusterState state) {
        DeprecationIssue deprecationIssue;
        TreeSet templatesWithMultipleTypes = new TreeSet();
        TreeSet templatesWithCustomTypes = new TreeSet();
        HashSet systemTemplatesWithCustomTypes = Sets.newHashSet((Object[])new String[]{".triggered_watches", ".watch-history-9", ".watches"});
        state.getMetadata().getTemplates().forEach(templateCursor -> {
            String templateName = (String)templateCursor.key;
            ImmutableOpenMap mappings = ((IndexTemplateMetadata)templateCursor.value).mappings();
            if (mappings != null) {
                boolean hasCustomType;
                if (mappings.size() > 1) {
                    templatesWithMultipleTypes.add(templateName);
                }
                if ((hasCustomType = mappings.stream().anyMatch(mapping -> {
                    String typeName = (String)mapping.getKey();
                    return !"_doc".equals(typeName);
                })) && !systemTemplatesWithCustomTypes.contains(templateName)) {
                    templatesWithCustomTypes.add(templateName);
                }
            }
        });
        if (templatesWithMultipleTypes.isEmpty() && templatesWithCustomTypes.isEmpty()) {
            deprecationIssue = null;
        } else if (templatesWithMultipleTypes.isEmpty()) {
            deprecationIssue = new DeprecationIssue(DeprecationIssue.Level.WARNING, "Custom mapping types in index templates are deprecated", "https://ela.st/es-deprecation-7-custom-types", "Update or remove the following index templates before upgrading to 8.0: " + templatesWithCustomTypes + ". See https://ela.st/es-deprecation-7-removal-of-types for alternatives to mapping types.", false, null);
        } else {
            TreeSet allBadTemplates = new TreeSet();
            allBadTemplates.addAll(templatesWithMultipleTypes);
            allBadTemplates.addAll(templatesWithCustomTypes);
            deprecationIssue = new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Multiple mapping types and custom mapping types in index templates and indices are deprecated", "https://ela.st/es-deprecation-7-multiple-types", "Update or remove the following index templates before upgrading to 8.0: " + allBadTemplates + ". See https://ela.st/es-deprecation-7-removal-of-types for alternatives to mapping types.", false, null);
        }
        return deprecationIssue;
    }

    private static Map<String, List<String>> getComponentTemplatesWithDeprecatedGeoShapeProperties(Map<String, ComponentTemplate> componentTemplates) {
        Map<String, List<String>> detailsForComponentTemplates = componentTemplates.entrySet().stream().map(templateCursor -> {
            String templateName = (String)templateCursor.getKey();
            ComponentTemplate componentTemplate = (ComponentTemplate)templateCursor.getValue();
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                Tuple tuple = XContentHelper.convertToMap((BytesReference)mappings.uncompressed(), (boolean)true, (XContentType)XContentType.JSON);
                Map mappingAsMap = (Map)tuple.v2();
                List messages = mappingAsMap == null ? Collections.emptyList() : IndexDeprecationChecks.findInPropertiesRecursively("geo_shape", mappingAsMap, IndexDeprecationChecks::isGeoShapeFieldWithDeprecatedParam, IndexDeprecationChecks::formatDeprecatedGeoShapeParamMessage, "[", "]");
                return Tuple.tuple((Object)templateName, messages);
            }
            return null;
        }).filter(templateToMessagesTuple -> templateToMessagesTuple != null && !((List)templateToMessagesTuple.v2()).isEmpty()).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        return detailsForComponentTemplates;
    }

    private static Map<String, List<String>> getIndexTemplatesWithDeprecatedGeoShapeProperties(ImmutableOpenMap<String, IndexTemplateMetadata> indexTemplates) {
        Map<String, List<String>> detailsForIndexTemplates = StreamSupport.stream(indexTemplates.spliterator(), false).map(templateCursor -> {
            String templateName = (String)templateCursor.key;
            IndexTemplateMetadata indexTemplateMetadata = (IndexTemplateMetadata)templateCursor.value;
            List messagesForTemplate = StreamSupport.stream(indexTemplateMetadata.getMappings().spliterator(), false).map(mappingCursor -> {
                CompressedXContent mapping = (CompressedXContent)mappingCursor.value;
                Tuple tuple = XContentHelper.convertToMap((BytesReference)mapping.uncompressed(), (boolean)true, (XContentType)XContentType.JSON);
                Map mappingAsMap = (Map)((Map)tuple.v2()).get("_doc");
                List messages = mappingAsMap == null ? Collections.emptyList() : IndexDeprecationChecks.findInPropertiesRecursively("geo_shape", mappingAsMap, IndexDeprecationChecks::isGeoShapeFieldWithDeprecatedParam, IndexDeprecationChecks::formatDeprecatedGeoShapeParamMessage, "[", "]");
                return messages;
            }).filter(messages -> !messages.isEmpty()).flatMap(x -> x.stream()).collect(Collectors.toList());
            return Tuple.tuple((Object)templateName, messagesForTemplate);
        }).filter(templateToMessagesTuple -> templateToMessagesTuple != null && !((List)templateToMessagesTuple.v2()).isEmpty()).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        return detailsForIndexTemplates;
    }

    private static String getDetailsMessageForTemplatesWithDeprecations(Map<String, List<String>> templateToMessages, boolean forceIncludeTemplateName) {
        boolean includeTemplateName = forceIncludeTemplateName || templateToMessages.keySet().size() > 1;
        return templateToMessages.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(entry -> {
            StringBuilder message = new StringBuilder();
            if (includeTemplateName) {
                message.append("[");
                message.append((String)entry.getKey());
                message.append(": ");
            }
            message.append(((List)entry.getValue()).stream().collect(Collectors.joining("; ")));
            if (includeTemplateName) {
                message.append("]");
            }
            return message;
        }).collect(Collectors.joining("; "));
    }

    static DeprecationIssue checkGeoShapeTemplates(ClusterState clusterState) {
        Map<String, List<String>> componentTemplatesToMessagesMap = ClusterDeprecationChecks.getComponentTemplatesWithDeprecatedGeoShapeProperties(clusterState.getMetadata().componentTemplates());
        Map<String, List<String>> indexTemplatesToMessagesMap = ClusterDeprecationChecks.getIndexTemplatesWithDeprecatedGeoShapeProperties((ImmutableOpenMap<String, IndexTemplateMetadata>)clusterState.getMetadata().getTemplates());
        boolean deprecationInComponentTemplates = !componentTemplatesToMessagesMap.isEmpty();
        boolean deprecationInIndexTemplates = !indexTemplatesToMessagesMap.isEmpty();
        String url = "https://ela.st/es-deprecation-7-geo-shape-mappings";
        if (deprecationInComponentTemplates && deprecationInIndexTemplates) {
            String message = String.format(Locale.ROOT, "[%s] component template%s and [%s] index template%s use deprecated geo_shape properties", componentTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), componentTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", indexTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), indexTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "");
            String details = String.format(Locale.ROOT, "Remove the following deprecated geo_shape properties from the mappings: %s; %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(componentTemplatesToMessagesMap, true), ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(indexTemplatesToMessagesMap, true));
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
        }
        if (!deprecationInComponentTemplates && deprecationInIndexTemplates) {
            String message = String.format(Locale.ROOT, "[%s] index template%s use%s deprecated geo_shape properties", indexTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), indexTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", indexTemplatesToMessagesMap.keySet().size() > 1 ? "" : "s");
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, String.format(Locale.ROOT, "Remove the following deprecated geo_shape properties from the mappings: %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(indexTemplatesToMessagesMap, false)), false, null);
        }
        if (!deprecationInIndexTemplates && deprecationInComponentTemplates) {
            String message = String.format(Locale.ROOT, "[%s] component template%s use%s deprecated geo_shape properties", componentTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), componentTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", componentTemplatesToMessagesMap.keySet().size() > 1 ? "" : "s");
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, String.format(Locale.ROOT, "Remove the following deprecated geo_shape properties from the mappings: %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(componentTemplatesToMessagesMap, false)), false, null);
        }
        return null;
    }

    protected static boolean isSparseVector(Map<?, ?> property) {
        return SPARSE_VECTOR.equals(property.get("type"));
    }

    protected static String formatDeprecatedSparseVectorMessage(String type, Map.Entry<?, ?> entry) {
        return entry.getKey().toString();
    }

    private static Map<String, List<String>> getComponentTemplatesWithDeprecatedSparseVectorProperties(Map<String, ComponentTemplate> componentTemplates) {
        Map<String, List<String>> detailsForComponentTemplates = componentTemplates.entrySet().stream().map(templateCursor -> {
            String templateName = (String)templateCursor.getKey();
            ComponentTemplate componentTemplate = (ComponentTemplate)templateCursor.getValue();
            CompressedXContent mappings = componentTemplate.template().mappings();
            if (mappings != null) {
                List messages;
                Tuple tuple = XContentHelper.convertToMap((BytesReference)mappings.uncompressed(), (boolean)true, (XContentType)XContentType.JSON);
                Map mappingAsMap = (Map)tuple.v2();
                List<Object> list = messages = mappingAsMap == null ? Collections.emptyList() : IndexDeprecationChecks.findInPropertiesRecursively(SPARSE_VECTOR, mappingAsMap, ClusterDeprecationChecks::isSparseVector, ClusterDeprecationChecks::formatDeprecatedSparseVectorMessage, "[", "]");
                if (!messages.isEmpty()) {
                    return Tuple.tuple((Object)templateName, messages);
                }
            }
            return null;
        }).filter(templateToMessagesTuple -> templateToMessagesTuple != null && !((List)templateToMessagesTuple.v2()).isEmpty()).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        return detailsForComponentTemplates;
    }

    private static Map<String, List<String>> getIndexTemplatesWithDeprecatedSparseVectorProperties(ImmutableOpenMap<String, IndexTemplateMetadata> indexTemplates) {
        Map<String, List<String>> detailsForIndexTemplates = StreamSupport.stream(indexTemplates.spliterator(), false).map(templateCursor -> {
            String templateName = (String)templateCursor.key;
            IndexTemplateMetadata indexTemplateMetadata = (IndexTemplateMetadata)templateCursor.value;
            List messagesForTemplate = StreamSupport.stream(indexTemplateMetadata.getMappings().spliterator(), false).map(mappingCursor -> {
                CompressedXContent mapping = (CompressedXContent)mappingCursor.value;
                Tuple tuple = XContentHelper.convertToMap((BytesReference)mapping.uncompressed(), (boolean)true, (XContentType)XContentType.JSON);
                Map mappingAsMap = (Map)((Map)tuple.v2()).get("_doc");
                List messages = mappingAsMap == null ? Collections.emptyList() : IndexDeprecationChecks.findInPropertiesRecursively(SPARSE_VECTOR, mappingAsMap, ClusterDeprecationChecks::isSparseVector, ClusterDeprecationChecks::formatDeprecatedSparseVectorMessage, "[", "]");
                return messages;
            }).filter(messages -> !messages.isEmpty()).flatMap(x -> x.stream()).collect(Collectors.toList());
            return Tuple.tuple((Object)templateName, messagesForTemplate);
        }).filter(templateToMessagesTuple -> templateToMessagesTuple != null && !((List)templateToMessagesTuple.v2()).isEmpty()).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
        return detailsForIndexTemplates;
    }

    static DeprecationIssue checkSparseVectorTemplates(ClusterState clusterState) {
        Map<String, List<String>> componentTemplatesToMessagesMap = ClusterDeprecationChecks.getComponentTemplatesWithDeprecatedSparseVectorProperties(clusterState.getMetadata().componentTemplates());
        Map<String, List<String>> indexTemplatesToMessagesMap = ClusterDeprecationChecks.getIndexTemplatesWithDeprecatedSparseVectorProperties((ImmutableOpenMap<String, IndexTemplateMetadata>)clusterState.getMetadata().getTemplates());
        boolean deprecationInComponentTemplates = !componentTemplatesToMessagesMap.isEmpty();
        boolean deprecationInIndexTemplates = !indexTemplatesToMessagesMap.isEmpty();
        String url = "https://ela.st/es-deprecation-7-sparse-vector";
        if (deprecationInComponentTemplates && deprecationInIndexTemplates) {
            String message = String.format(Locale.ROOT, "[%s] component template%s and [%s] index template%s use deprecated sparse_vector properties", componentTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), componentTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", indexTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), indexTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "");
            String details = String.format(Locale.ROOT, "Remove the following deprecated sparse_vector properties from the mappings: %s; %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(componentTemplatesToMessagesMap, true), ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(indexTemplatesToMessagesMap, true));
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, details, false, null);
        }
        if (!deprecationInComponentTemplates && deprecationInIndexTemplates) {
            String message = String.format(Locale.ROOT, "[%s] index template%s use%s deprecated sparse_vector properties", indexTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), indexTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", indexTemplatesToMessagesMap.keySet().size() > 1 ? "" : "s");
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, String.format(Locale.ROOT, "Remove the following deprecated sparse_vector properties from the mappings: %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(indexTemplatesToMessagesMap, false)), false, null);
        }
        if (!deprecationInIndexTemplates && deprecationInComponentTemplates) {
            String message = String.format(Locale.ROOT, "[%s] component template%s use%s deprecated sparse_vector properties", componentTemplatesToMessagesMap.keySet().stream().collect(Collectors.joining(",")), componentTemplatesToMessagesMap.keySet().size() > 1 ? "s" : "", componentTemplatesToMessagesMap.keySet().size() > 1 ? "" : "s");
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, message, url, String.format(Locale.ROOT, "Remove the following deprecated sparse_vector properties from the mappings: %s.", ClusterDeprecationChecks.getDetailsMessageForTemplatesWithDeprecations(componentTemplatesToMessagesMap, false)), false, null);
        }
        return null;
    }

    static DeprecationIssue checkILMFreezeActions(ClusterState state) {
        List policiesWithFreezeActions;
        IndexLifecycleMetadata indexLifecycleMetadata = (IndexLifecycleMetadata)state.getMetadata().custom("index_lifecycle");
        if (indexLifecycleMetadata != null && !(policiesWithFreezeActions = indexLifecycleMetadata.getPolicies().entrySet().stream().filter(nameAndPolicy -> ((LifecyclePolicy)nameAndPolicy.getValue()).getPhases().values().stream().anyMatch(phase -> phase != null && phase.getActions() != null && phase.getActions().containsKey("freeze"))).map(nameAndPolicy -> (String)nameAndPolicy.getKey()).collect(Collectors.toList())).isEmpty()) {
            String details = String.format(Locale.ROOT, "Remove the freeze action from ILM policies: [%s]", policiesWithFreezeActions.stream().sorted().collect(Collectors.joining(",")));
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "ILM policies use the deprecated freeze action", "https://ela.st/es-deprecation-7-frozen-indices", details, false, null);
        }
        return null;
    }

    static DeprecationIssue checkTransientSettingsExistence(ClusterState state) {
        if (!state.metadata().transientSettings().isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Transient cluster settings are deprecated", "https://ela.st/es-deprecation-7-transient-cluster-settings", "Use persistent settings to configure your cluster.", false, null);
        }
        return null;
    }

    static DeprecationIssue checkShards(ClusterState clusterState) {
        int shardsInFutureNewSmallIndex = 5;
        boolean replicasForFutureIndex = true;
        if (ShardLimitValidator.canAddShardsToCluster((int)5, (int)1, (ClusterState)clusterState, (boolean)false)) {
            return null;
        }
        int totalShardsToAdd = 10;
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "The cluster has too many shards to be able to upgrade", "https://ela.st/es-deprecation-7-shard-limit", String.format(Locale.ROOT, "Upgrading requires adding a small number of new shards. There is not enough room for %d more shards. Increase the cluster.max_shards_per_node setting, or remove indices to clear up resources.", 10), false, null);
    }

    static DeprecationIssue emptyDataTierPreferenceCheck(ClusterState clusterState) {
        if (!DataTier.dataNodesWithoutAllDataRoles((ClusterState)clusterState).isEmpty()) {
            ArrayList<String> indices = new ArrayList<String>();
            for (IndexMetadata indexMetadata : clusterState.metadata().getIndices().values()) {
                List tierPreference = DataTier.parseTierList((String)((String)DataTier.TIER_PREFERENCE_SETTING.get(indexMetadata.getSettings())));
                if (!tierPreference.isEmpty()) continue;
                String indexName = indexMetadata.getIndex().getName();
                indices.add(indexName);
            }
            if (!indices.isEmpty()) {
                Map<Boolean, List<String>> groups = indices.stream().collect(Collectors.partitioningBy(s -> s.startsWith(".")));
                ArrayList noLeadingPeriod = new ArrayList(groups.get(false));
                ArrayList leadingPeriod = new ArrayList(groups.get(true));
                Collections.sort(noLeadingPeriod);
                Collections.sort(leadingPeriod);
                noLeadingPeriod.addAll(leadingPeriod);
                indices = noLeadingPeriod;
                StringBuilder builder = new StringBuilder();
                Strings.collectionToDelimitedStringWithLimit(indices, (String)", ", (String)"", (String)"", (int)256, (StringBuilder)builder);
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "No [index.routing.allocation.include._tier_preference] is set for indices [" + builder + "].", "https://ela.st/es-deprecation-7-empty-tier-preference", "Specify a data tier preference for these indices.", false, null);
            }
        }
        return null;
    }
}

