/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SamlValidateAuthnRequestRequest
extends ActionRequest {
    private String queryString;

    public SamlValidateAuthnRequestRequest(StreamInput in) throws IOException {
        super(in);
        this.queryString = in.readString();
    }

    public SamlValidateAuthnRequestRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.queryString)) {
            validationException = ValidateActions.addValidationError((String)"Authentication request query string must be provided", validationException);
        }
        return validationException;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.queryString);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{queryString='" + this.queryString + "'}";
    }
}

