/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.parser.AbstractBuilder;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public TableIdentifier visitTableIdentifier(SqlBaseParser.TableIdentifierContext ctx) {
        if (ctx == null) {
            return null;
        }
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        SqlBaseParser.IdentifierContext tree = ctx.name != null ? ctx.name : ctx.TABLE_IDENTIFIER();
        String index = tree.getText();
        return new TableIdentifier(source, this.visitIdentifier(ctx.catalog), IdentifierBuilder.unquoteIdentifier(index));
    }

    @Override
    public String visitIdentifier(SqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.getText());
    }

    @Override
    public String visitQualifiedName(SqlBaseParser.QualifiedNameContext ctx) {
        if (ctx == null) {
            return null;
        }
        return Strings.collectionToDelimitedString((Iterable)ParserUtils.visitList((ParseTreeVisitor)this, ctx.identifier(), String.class), (String)".");
    }

    private static String unquoteIdentifier(String identifier) {
        return identifier.replace("\"\"", "\"");
    }
}

