/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.common.io;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Base64;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class SqlStreamInput
extends NamedWriteableAwareStreamInput {
    private final ZoneId zoneId;

    public SqlStreamInput(String base64encoded, NamedWriteableRegistry namedWriteableRegistry, Version version) throws IOException {
        this(Base64.getDecoder().decode(base64encoded), namedWriteableRegistry, version);
    }

    public SqlStreamInput(byte[] input, NamedWriteableRegistry namedWriteableRegistry, Version version) throws IOException {
        super(StreamInput.wrap((byte[])input), namedWriteableRegistry);
        Version ver = Version.readVersion((StreamInput)this.delegate);
        if (version.compareTo(ver) != 0) {
            throw new SqlIllegalArgumentException("Unsupported cursor version [{}], expected [{}]", ver, version);
        }
        this.delegate.setVersion(version);
        this.zoneId = this.delegate.readZoneId();
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public static SqlStreamInput asSqlStream(StreamInput in) {
        if (in instanceof SqlStreamInput) {
            return (SqlStreamInput)in;
        }
        throw new SqlIllegalArgumentException("Expected SQL cursor stream, received [{}]", in.getClass());
    }
}

