/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.transform.TransformField;

public class TransformTaskParams
extends AbstractDiffable<TransformTaskParams>
implements XPackPlugin.XPackPersistentTaskParams {
    public static final String NAME = "data_frame/transforms";
    public static final ParseField FREQUENCY = TransformField.FREQUENCY;
    public static final ParseField REQUIRES_REMOTE = new ParseField("requires_remote", new String[0]);
    private final String transformId;
    private final Version version;
    private final TimeValue frequency;
    private final Boolean requiresRemote;
    public static final ConstructingObjectParser<TransformTaskParams, Void> PARSER = new ConstructingObjectParser("data_frame/transforms", true, a -> new TransformTaskParams((String)a[0], (String)a[1], (String)a[2], (Boolean)a[3]));

    private TransformTaskParams(String transformId, String version, String frequency, Boolean remote) {
        this(transformId, version == null ? null : Version.fromString((String)version), frequency == null ? null : TimeValue.parseTimeValue((String)frequency, (String)FREQUENCY.getPreferredName()), remote == null ? false : remote);
    }

    public TransformTaskParams(String transformId, Version version, TimeValue frequency, boolean remote) {
        this.transformId = transformId;
        this.version = version == null ? Version.V_7_2_0 : version;
        this.frequency = frequency;
        this.requiresRemote = remote;
    }

    public TransformTaskParams(StreamInput in) throws IOException {
        this.transformId = in.readString();
        this.version = in.getVersion().onOrAfter(Version.V_7_3_0) ? Version.readVersion((StreamInput)in) : Version.V_7_2_0;
        this.frequency = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalTimeValue() : null;
        this.requiresRemote = in.getVersion().onOrAfter(Version.V_7_7_0) ? Boolean.valueOf(in.readBoolean()) : Boolean.valueOf(false);
    }

    public String getWriteableName() {
        return NAME;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_2_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.transformId);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            Version.writeVersion((Version)this.version, (StreamOutput)out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalTimeValue(this.frequency);
        }
        if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
            out.writeBoolean(this.requiresRemote.booleanValue());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.transformId);
        builder.field(TransformField.VERSION.getPreferredName(), (ToXContent)this.version);
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        builder.field(REQUIRES_REMOTE.getPreferredName(), this.requiresRemote);
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.transformId;
    }

    public Version getVersion() {
        return this.version;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public boolean requiresRemote() {
        return this.requiresRemote;
    }

    public static TransformTaskParams fromXContent(XContentParser parser) throws IOException {
        return (TransformTaskParams)PARSER.parse(parser, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformTaskParams that = (TransformTaskParams)other;
        return Objects.equals(this.transformId, that.transformId) && Objects.equals(this.version, that.version) && Objects.equals(this.frequency, that.frequency) && this.requiresRemote == that.requiresRemote;
    }

    public int hashCode() {
        return Objects.hash(this.transformId, this.version, this.frequency, this.requiresRemote);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TransformField.ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.VERSION);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FREQUENCY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REQUIRES_REMOTE);
    }
}

