/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action.compat;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;

public class UpdateTransformActionPre78 {

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final TransformConfig config;

        public Response(TransformConfig config) {
            this.config = config;
        }

        public Response(StreamInput in) throws IOException {
            assert (in.getVersion().before(Version.V_7_8_0));
            this.config = new TransformConfig(in);
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getVersion().before(Version.V_7_8_0));
            this.config.writeTo(out);
        }

        public int hashCode() {
            return this.config.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TransformConfigUpdate update;
        private final String id;
        private final boolean deferValidation;

        public Request(TransformConfigUpdate update, String id, boolean deferValidation) {
            this.update = update;
            this.id = id;
            this.deferValidation = deferValidation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getVersion().before(Version.V_7_8_0));
            this.update = new TransformConfigUpdate(in);
            this.id = in.readString();
            this.deferValidation = in.readBoolean();
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation) {
            return new Request(TransformConfigUpdate.fromXContent(parser), id, deferValidation);
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public TransformConfigUpdate getUpdate() {
            return this.update;
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getVersion().before(Version.V_7_8_0));
            super.writeTo(out);
            this.update.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.deferValidation);
        }

        public int hashCode() {
            return Objects.hash(this.update, this.id, this.deferValidation);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.update, other.update) && this.deferValidation == other.deferValidation && this.id.equals(other.id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

