/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.core.termsenum.action.TermCount;

public class SimpleTermCountEnum
extends TermsEnum {
    int index = -1;
    TermCount[] sortedTerms;
    TermCount current = null;

    public SimpleTermCountEnum(TermCount[] terms) {
        this.sortedTerms = Arrays.copyOf(terms, terms.length);
        Arrays.sort(this.sortedTerms, Comparator.comparing(TermCount::getTerm));
    }

    public SimpleTermCountEnum(TermCount termCount) {
        this.sortedTerms = new TermCount[1];
        this.sortedTerms[0] = termCount;
    }

    public BytesRef term() throws IOException {
        if (this.current == null) {
            return null;
        }
        return new BytesRef((CharSequence)this.current.getTerm());
    }

    public BytesRef next() throws IOException {
        ++this.index;
        this.current = this.index >= this.sortedTerms.length ? null : this.sortedTerms[this.index];
        return this.term();
    }

    public int docFreq() throws IOException {
        if (this.current == null) {
            return 0;
        }
        return (int)this.current.getDocCount();
    }

    public AttributeSource attributes() {
        throw new UnsupportedOperationException();
    }

    public boolean seekExact(BytesRef text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seekExact(long ord) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seekExact(BytesRef term, TermState state) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long ord() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long totalTermFreq() throws IOException {
        throw new UnsupportedOperationException();
    }

    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ImpactsEnum impacts(int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TermState termState() throws IOException {
        throw new UnsupportedOperationException();
    }
}

