/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CleanupSnapshotStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.CopySettingsStep;
import org.elasticsearch.xpack.core.ilm.CreateSnapshotStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.ForceMergeStep;
import org.elasticsearch.xpack.core.ilm.GenerateSnapshotNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.MountSnapshotStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.SegmentCountStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;
import org.elasticsearch.xpack.core.ilm.WaitForDataTierStep;
import org.elasticsearch.xpack.core.ilm.WaitForIndexColorStep;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;

public class SearchableSnapshotAction
implements LifecycleAction {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotAction.class);
    public static final String NAME = "searchable_snapshot";
    public static final ParseField SNAPSHOT_REPOSITORY = new ParseField("snapshot_repository", new String[0]);
    public static final ParseField FORCE_MERGE_INDEX = new ParseField("force_merge_index", new String[0]);
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    public static final String CONDITIONAL_SKIP_ACTION_STEP = "branch-check-prerequisites";
    public static final String CONDITIONAL_SKIP_GENERATE_AND_CLEAN = "branch-check-existing-snapshot";
    public static final String FULL_RESTORED_INDEX_PREFIX = "restored-";
    public static final String PARTIAL_RESTORED_INDEX_PREFIX = "partial-";
    private static final ConstructingObjectParser<SearchableSnapshotAction, Void> PARSER = new ConstructingObjectParser("searchable_snapshot", a -> new SearchableSnapshotAction((String)a[0], a[1] == null || (Boolean)a[1] != false));
    private final String snapshotRepository;
    private final boolean forceMergeIndex;

    public static SearchableSnapshotAction parse(XContentParser parser) {
        return (SearchableSnapshotAction)PARSER.apply(parser, null);
    }

    public SearchableSnapshotAction(String snapshotRepository, boolean forceMergeIndex) {
        if (!Strings.hasText((String)snapshotRepository)) {
            throw new IllegalArgumentException("the snapshot repository must be specified");
        }
        this.snapshotRepository = snapshotRepository;
        this.forceMergeIndex = forceMergeIndex;
    }

    public SearchableSnapshotAction(String snapshotRepository) {
        this(snapshotRepository, true);
    }

    public SearchableSnapshotAction(StreamInput in) throws IOException {
        this.snapshotRepository = in.readString();
        this.forceMergeIndex = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readBoolean() : true;
    }

    boolean isForceMergeIndex() {
        return this.forceMergeIndex;
    }

    public String getSnapshotRepository() {
        return this.snapshotRepository;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        assert (false);
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey, XPackLicenseState licenseState) {
        Step.StepKey preActionBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_ACTION_STEP);
        Step.StepKey checkNoWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey forceMergeStepKey = new Step.StepKey(phase, NAME, "forcemerge");
        Step.StepKey waitForSegmentCountKey = new Step.StepKey(phase, NAME, "segment-count");
        Step.StepKey skipGeneratingSnapshotKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_GENERATE_AND_CLEAN);
        Step.StepKey generateSnapshotNameKey = new Step.StepKey(phase, NAME, "generate-snapshot-name");
        Step.StepKey cleanSnapshotKey = new Step.StepKey(phase, NAME, "cleanup-snapshot");
        Step.StepKey createSnapshotKey = new Step.StepKey(phase, NAME, "create-snapshot");
        Step.StepKey waitForDataTierKey = new Step.StepKey(phase, NAME, "wait-for-data-tier");
        Step.StepKey mountSnapshotKey = new Step.StepKey(phase, NAME, "mount-snapshot");
        Step.StepKey waitForGreenRestoredIndexKey = new Step.StepKey(phase, NAME, "wait-for-index-color");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey copyLifecyclePolicySettingKey = new Step.StepKey(phase, NAME, "copy-settings");
        Step.StepKey swapAliasesKey = new Step.StepKey(phase, NAME, "swap-aliases");
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteIndexKey = new Step.StepKey(phase, NAME, "delete");
        BranchingStep conditionalSkipActionStep = new BranchingStep(preActionBranchingKey, checkNoWriteIndex, nextStepKey, (index, clusterState) -> {
            if (!SearchableSnapshotsConstants.SEARCHABLE_SNAPSHOT_FEATURE.checkWithoutTracking(licenseState)) {
                logger.error("[{}] action is not available in the current license", (Object)NAME);
                throw LicenseUtils.newComplianceException("searchable-snapshots");
            }
            IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
            assert (indexMetadata != null) : "index " + index.getName() + " must exist in the cluster state";
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
            SearchableSnapshotMetadata searchableSnapshotMetadata = SearchableSnapshotAction.extractSearchableSnapshotFromSettings(indexMetadata);
            if (searchableSnapshotMetadata != null) {
                MountSearchableSnapshotRequest.Storage type;
                if (!this.snapshotRepository.equals(searchableSnapshotMetadata.repositoryName)) {
                    logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot, but with a different repository (existing: [{}] vs new: [{}]), a new snapshot and index will be created", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)searchableSnapshotMetadata.repositoryName, (Object)this.snapshotRepository);
                    return false;
                }
                MountSearchableSnapshotRequest.Storage existingType = searchableSnapshotMetadata.partial ? MountSearchableSnapshotRequest.Storage.SHARED_CACHE : MountSearchableSnapshotRequest.Storage.FULL_COPY;
                if (existingType == (type = this.getConcreteStorageType(preActionBranchingKey))) {
                    logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot with the same repository [{}] and storage type [{}], skipping this action", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)searchableSnapshotMetadata.repositoryName, (Object)type);
                    return true;
                }
                logger.debug("[{}] action is configured for index [{}] in policy [{}] which is already mounted as a searchable snapshot in repository [{}], however, the storage type ([{}] vs [{}]) differs, so a new index will be created", (Object)NAME, (Object)index.getName(), (Object)policyName, (Object)this.snapshotRepository, (Object)existingType, (Object)type);
                return false;
            }
            return false;
        });
        CheckNotDataStreamWriteIndexStep checkNoWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNoWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, skipGeneratingSnapshotKey, client);
        Step.StepKey keyForSnapshotGeneration = this.forceMergeIndex ? forceMergeStepKey : generateSnapshotNameKey;
        BranchingStep skipGeneratingSnapshotStep = new BranchingStep(skipGeneratingSnapshotKey, keyForSnapshotGeneration, waitForDataTierKey, (index, clusterState) -> {
            String repoName;
            String snapshotName;
            String snapshotIndexName;
            IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
            String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
            LifecycleExecutionState lifecycleExecutionState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
            SearchableSnapshotMetadata searchableSnapshotMetadata = SearchableSnapshotAction.extractSearchableSnapshotFromSettings(indexMetadata);
            if (lifecycleExecutionState.getSnapshotName() == null && searchableSnapshotMetadata == null) {
                logger.trace("no snapshot name for index [{}] in policy [{}] exists, so one will be generated", (Object)index.getName(), (Object)policyName);
                return false;
            }
            if (lifecycleExecutionState.getSnapshotName() != null) {
                snapshotIndexName = lifecycleExecutionState.getSnapshotIndexName();
                snapshotName = lifecycleExecutionState.getSnapshotName();
                repoName = lifecycleExecutionState.getSnapshotRepository();
            } else {
                snapshotIndexName = searchableSnapshotMetadata.sourceIndex;
                snapshotName = searchableSnapshotMetadata.snapshotName;
                repoName = searchableSnapshotMetadata.repositoryName;
            }
            if (!this.snapshotRepository.equals(repoName)) {
                throw new IllegalArgumentException("searchable snapshot indices may be converted only within the same repository");
            }
            logger.debug("Policy [{}] will use an existing snapshot [{}] in repository [{}] (index name: [{}]) to mount [{}] as a searchable snapshot. This snapshot was found in the {}.", (Object)policyName, (Object)snapshotName, (Object)this.snapshotRepository, (Object)snapshotIndexName, (Object)index.getName(), (Object)(lifecycleExecutionState.getSnapshotName() != null ? "lifecycle execution state" : "metadata of " + index.getName()));
            return true;
        });
        ForceMergeStep forceMergeStep = new ForceMergeStep(forceMergeStepKey, waitForSegmentCountKey, client, 1);
        SegmentCountStep segmentCountStep = new SegmentCountStep(waitForSegmentCountKey, generateSnapshotNameKey, client, 1);
        GenerateSnapshotNameStep generateSnapshotNameStep = new GenerateSnapshotNameStep(generateSnapshotNameKey, cleanSnapshotKey, this.snapshotRepository);
        CleanupSnapshotStep cleanupSnapshotStep = new CleanupSnapshotStep(cleanSnapshotKey, createSnapshotKey, client);
        CreateSnapshotStep createSnapshotStep = new CreateSnapshotStep(createSnapshotKey, waitForDataTierKey, cleanSnapshotKey, client);
        MountSearchableSnapshotRequest.Storage storageType = this.getConcreteStorageType(mountSnapshotKey);
        WaitForDataTierStep waitForDataTierStep = new WaitForDataTierStep(waitForDataTierKey, mountSnapshotKey, MountSnapshotStep.overrideTierPreference(phase).orElse(storageType.defaultDataTiersPreference()));
        MountSnapshotStep mountSnapshotStep = new MountSnapshotStep(mountSnapshotKey, waitForGreenRestoredIndexKey, client, this.getRestoredIndexPrefix(mountSnapshotKey), storageType);
        WaitForIndexColorStep waitForGreenIndexHealthStep = new WaitForIndexColorStep(waitForGreenRestoredIndexKey, copyMetadataKey, ClusterHealthStatus.GREEN, this.getRestoredIndexPrefix(waitForGreenRestoredIndexKey));
        CopyExecutionStateStep copyMetadataStep = new CopyExecutionStateStep(copyMetadataKey, copyLifecyclePolicySettingKey, (index, executionState) -> this.getRestoredIndexPrefix(copyMetadataKey) + index, nextStepKey);
        CopySettingsStep copySettingsStep = new CopySettingsStep(copyLifecyclePolicySettingKey, dataStreamCheckBranchingKey, this.getRestoredIndexPrefix(copyLifecyclePolicySettingKey), "index.lifecycle.name");
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, swapAliasesKey, replaceDataStreamIndexKey, (index, clusterState) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteIndexKey, (index, executionState) -> this.getRestoredIndexPrefix(replaceDataStreamIndexKey) + index);
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteIndexKey, null, client);
        SwapAliasesAndDeleteSourceIndexStep swapAliasesAndDeleteSourceIndexStep = new SwapAliasesAndDeleteSourceIndexStep(swapAliasesKey, null, client, this.getRestoredIndexPrefix(swapAliasesKey));
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(conditionalSkipActionStep);
        steps.add(checkNoWriteIndexStep);
        steps.add(waitForNoFollowersStep);
        steps.add(skipGeneratingSnapshotStep);
        if (this.forceMergeIndex) {
            steps.add(forceMergeStep);
            steps.add(segmentCountStep);
        }
        steps.add(generateSnapshotNameStep);
        steps.add(cleanupSnapshotStep);
        steps.add(createSnapshotStep);
        steps.add(waitForDataTierStep);
        steps.add(mountSnapshotStep);
        steps.add(waitForGreenIndexHealthStep);
        steps.add(copyMetadataStep);
        steps.add(copySettingsStep);
        steps.add(isDataStreamBranchingStep);
        steps.add(replaceDataStreamBackingIndex);
        steps.add(deleteSourceIndexStep);
        steps.add(swapAliasesAndDeleteSourceIndexStep);
        return steps;
    }

    String getRestoredIndexPrefix(Step.StepKey currentKey) {
        if (currentKey.getPhase().equals("frozen")) {
            return PARTIAL_RESTORED_INDEX_PREFIX;
        }
        return FULL_RESTORED_INDEX_PREFIX;
    }

    MountSearchableSnapshotRequest.Storage getConcreteStorageType(Step.StepKey currentKey) {
        if (currentKey.getPhase().equals("frozen")) {
            return MountSearchableSnapshotRequest.Storage.SHARED_CACHE;
        }
        return MountSearchableSnapshotRequest.Storage.FULL_COPY;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.snapshotRepository);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.forceMergeIndex);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_REPOSITORY.getPreferredName(), this.snapshotRepository);
        builder.field(FORCE_MERGE_INDEX.getPreferredName(), this.forceMergeIndex);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchableSnapshotAction that = (SearchableSnapshotAction)o;
        return Objects.equals(this.snapshotRepository, that.snapshotRepository) && Objects.equals(this.forceMergeIndex, that.forceMergeIndex);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotRepository, this.forceMergeIndex);
    }

    @Nullable
    static SearchableSnapshotMetadata extractSearchableSnapshotFromSettings(IndexMetadata indexMetadata) {
        String indexName = indexMetadata.getSettings().get("index.store.snapshot.index_name");
        if (indexName == null) {
            return null;
        }
        String snapshotName = indexMetadata.getSettings().get("index.store.snapshot.snapshot_name");
        String repo = indexMetadata.getSettings().get("index.store.snapshot.repository_name");
        boolean partial = indexMetadata.getSettings().getAsBoolean("index.store.snapshot.partial", Boolean.valueOf(false));
        return new SearchableSnapshotMetadata(indexName, repo, snapshotName, partial);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_REPOSITORY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FORCE_MERGE_INDEX);
    }

    static class SearchableSnapshotMetadata {
        private final String sourceIndex;
        private final String repositoryName;
        private final String snapshotName;
        private final boolean partial;

        SearchableSnapshotMetadata(String sourceIndex, String repositoryName, String snapshotName, boolean partial) {
            this.sourceIndex = sourceIndex;
            this.repositoryName = repositoryName;
            this.snapshotName = snapshotName;
            this.partial = partial;
        }

        public String sourceIndex() {
            return this.sourceIndex;
        }

        public String repositoryName() {
            return this.repositoryName;
        }

        public String snapshotName() {
            return this.snapshotName;
        }

        public boolean partial() {
            return this.partial;
        }
    }
}

