/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Build;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.encrypted.EncryptedRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;

public class EncryptedRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    static final LicensedFeature.Momentary ENCRYPTED_SNAPSHOT_FEATURE = LicensedFeature.momentary(null, (String)"encrypted-snapshot", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final Boolean ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED;
    static final Logger logger;
    static final String REPOSITORY_TYPE_NAME = "encrypted";
    static final List<String> SUPPORTED_ENCRYPTED_TYPE_NAMES;
    static final Setting.AffixSetting<SecureString> ENCRYPTION_PASSWORD_SETTING;
    static final Setting<String> DELEGATE_TYPE_SETTING;
    static final Setting<String> PASSWORD_NAME_SETTING;

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(ENCRYPTION_PASSWORD_SETTING);
    }

    public static boolean isDisabled() {
        return false == Build.CURRENT.isSnapshot() && (ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED == null || ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED == false);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, final NamedXContentRegistry registry, final ClusterService clusterService, final BigArrays bigArrays, final RecoverySettings recoverySettings) {
        if (EncryptedRepositoryPlugin.isDisabled()) {
            return Collections.emptyMap();
        }
        HashMap<String, SecureString> repositoryPasswordsMapBuilder = new HashMap<String, SecureString>();
        for (String passwordName : ENCRYPTION_PASSWORD_SETTING.getNamespaces(env.settings())) {
            Setting passwordSetting = ENCRYPTION_PASSWORD_SETTING.getConcreteSettingForNamespace(passwordName);
            repositoryPasswordsMapBuilder.put(passwordName, (SecureString)passwordSetting.get(env.settings()));
            logger.debug("Loaded repository password [{}] from the node keystore", (Object)passwordName);
        }
        final HashMap<String, SecureString> repositoryPasswordsMap = repositoryPasswordsMapBuilder;
        return Collections.singletonMap(REPOSITORY_TYPE_NAME, new Repository.Factory(){

            public Repository create(RepositoryMetadata metadata) {
                throw new UnsupportedOperationException();
            }

            public Repository create(RepositoryMetadata metadata, Function<String, Repository.Factory> typeLookup) throws Exception {
                String delegateType = (String)DELEGATE_TYPE_SETTING.get(metadata.settings());
                if (!Strings.hasLength((String)delegateType)) {
                    throw new IllegalArgumentException("Repository setting [" + DELEGATE_TYPE_SETTING.getKey() + "] must be set");
                }
                if (EncryptedRepositoryPlugin.REPOSITORY_TYPE_NAME.equals(delegateType)) {
                    throw new IllegalArgumentException("Cannot encrypt an already encrypted repository. [" + DELEGATE_TYPE_SETTING.getKey() + "] must not be equal to [" + EncryptedRepositoryPlugin.REPOSITORY_TYPE_NAME + "]");
                }
                Repository.Factory factory = typeLookup.apply(delegateType);
                if (null == factory || !SUPPORTED_ENCRYPTED_TYPE_NAMES.contains(delegateType)) {
                    throw new IllegalArgumentException("Unsupported delegate repository type [" + delegateType + "] for setting [" + DELEGATE_TYPE_SETTING.getKey() + "]");
                }
                String repositoryPasswordName = (String)PASSWORD_NAME_SETTING.get(metadata.settings());
                if (!Strings.hasLength((String)repositoryPasswordName)) {
                    throw new IllegalArgumentException("Repository setting [" + PASSWORD_NAME_SETTING.getKey() + "] must be set");
                }
                SecureString repositoryPassword = (SecureString)repositoryPasswordsMap.get(repositoryPasswordName);
                if (repositoryPassword == null) {
                    throw new IllegalArgumentException("Secure setting [" + ENCRYPTION_PASSWORD_SETTING.getConcreteSettingForNamespace(repositoryPasswordName).getKey() + "] must be set");
                }
                Repository delegatedRepository = factory.create(new RepositoryMetadata(metadata.name(), delegateType, metadata.settings()));
                if (!(delegatedRepository instanceof BlobStoreRepository) || delegatedRepository instanceof EncryptedRepository) {
                    throw new IllegalArgumentException("Unsupported delegate repository type [" + DELEGATE_TYPE_SETTING.getKey() + "]");
                }
                if (!ENCRYPTED_SNAPSHOT_FEATURE.check(EncryptedRepositoryPlugin.this.getLicenseState())) {
                    logger.warn((Message)new ParameterizedMessage("Encrypted snapshots are not allowed for the currently installed license [{}]. Snapshots to the [{}] encrypted repository are not permitted. All the other operations, including restore, work without restrictions.", (Object)EncryptedRepositoryPlugin.this.getLicenseState().getOperationMode().description(), (Object)metadata.name()), (Throwable)LicenseUtils.newComplianceException((String)"encrypted snapshots"));
                }
                return EncryptedRepositoryPlugin.this.createEncryptedRepository(metadata, registry, clusterService, bigArrays, recoverySettings, (BlobStoreRepository)delegatedRepository, () -> EncryptedRepositoryPlugin.this.getLicenseState(), repositoryPassword);
            }
        });
    }

    protected EncryptedRepository createEncryptedRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, BlobStoreRepository delegatedRepository, Supplier<XPackLicenseState> licenseStateSupplier, SecureString repoPassword) throws GeneralSecurityException {
        return new EncryptedRepository(metadata, registry, clusterService, bigArrays, recoverySettings, delegatedRepository, licenseStateSupplier, repoPassword);
    }

    static {
        String property = System.getProperty("es.encrypted_repository_feature_flag_registered");
        if (Build.CURRENT.isSnapshot() && property != null) {
            throw new IllegalArgumentException("es.encrypted_repository_feature_flag_registered is only supported in non-snapshot builds");
        }
        if ("true".equals(property)) {
            ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED = true;
        } else if ("false".equals(property)) {
            ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED = false;
        } else if (property == null) {
            ENCRYPTED_REPOSITORY_FEATURE_FLAG_REGISTERED = null;
        } else {
            throw new IllegalArgumentException("expected es.encrypted_repository_feature_flag_registered to be unset or [true|false] but was [" + property + "]");
        }
        logger = LogManager.getLogger(EncryptedRepositoryPlugin.class);
        SUPPORTED_ENCRYPTED_TYPE_NAMES = Arrays.asList("fs", "gcs", "azure", "s3");
        ENCRYPTION_PASSWORD_SETTING = Setting.affixKeySetting((String)"repository.encrypted.", (String)"password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        DELEGATE_TYPE_SETTING = Setting.simpleString((String)"delegate_type", (String)"", (Setting.Property[])new Setting.Property[0]);
        PASSWORD_NAME_SETTING = Setting.simpleString((String)"password_name", (String)"", (Setting.Property[])new Setting.Property[0]);
    }
}

