/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.script;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.ql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.ql.expression.gen.script.Param;

class Agg
extends Param<AggregateFunction> {
    private static final String COUNT_PATH = "_count";

    Agg(AggregateFunction aggRef) {
        super(aggRef);
    }

    String aggName() {
        return Expressions.id((Expression)this.value());
    }

    public String aggProperty() {
        AggregateFunction agg = (AggregateFunction)this.value();
        if (agg instanceof InnerAggregate) {
            InnerAggregate inner = (InnerAggregate)agg;
            return Expressions.id((Expression)((Object)inner.outer())) + "." + inner.innerName();
        }
        if (agg instanceof Count) {
            Count c = (Count)agg;
            if (c.field().foldable()) {
                return COUNT_PATH;
            }
            if (c.distinct()) {
                return Expressions.id(c);
            }
            return Expressions.id(c) + "." + COUNT_PATH;
        }
        return null;
    }

    @Override
    public String prefix() {
        return "a";
    }
}

