/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.UnresolvedNamedExpression;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class UnresolvedAlias
extends UnresolvedNamedExpression {
    private final Expression child;

    public UnresolvedAlias(Source source, Expression child) {
        super(source, Collections.singletonList(child));
        this.child = child;
    }

    @Override
    protected NodeInfo<UnresolvedAlias> info() {
        return NodeInfo.create(this, UnresolvedAlias::new, this.child);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new UnresolvedAlias(this.source(), newChildren.get(0));
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public String unresolvedMessage() {
        return "Unknown alias [" + this.name() + "]";
    }

    @Override
    public Nullability nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.child, ((UnresolvedAlias)obj).child);
    }

    @Override
    public String toString() {
        return this.child + " AS ?";
    }

    @Override
    public String nodeString() {
        return this.toString();
    }
}

