/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.normalizer;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerBuilder;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.ProcessPipes;
import org.elasticsearch.xpack.ml.utils.NamedPipeHelper;

public class NativeNormalizerProcessFactory
implements NormalizerProcessFactory {
    private static final Logger logger = LogManager.getLogger(NativeNormalizerProcessFactory.class);
    private static final NamedPipeHelper NAMED_PIPE_HELPER = new NamedPipeHelper();
    private final Environment env;
    private final NativeController nativeController;
    private final String nodeName;
    private final AtomicLong counter;
    private volatile Duration processConnectTimeout;

    public NativeNormalizerProcessFactory(Environment env, NativeController nativeController, ClusterService clusterService) {
        this.env = Objects.requireNonNull(env);
        this.nativeController = Objects.requireNonNull(nativeController);
        this.nodeName = clusterService.getNodeName();
        this.counter = new AtomicLong(0L);
        this.setProcessConnectTimeout((TimeValue)MachineLearning.PROCESS_CONNECT_TIMEOUT.get(env.settings()));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.PROCESS_CONNECT_TIMEOUT, this::setProcessConnectTimeout);
    }

    void setProcessConnectTimeout(TimeValue processConnectTimeout) {
        this.processConnectTimeout = Duration.ofMillis(processConnectTimeout.getMillis());
    }

    @Override
    public NormalizerProcess createNormalizerProcess(String jobId, String quantilesState, Integer bucketSpan, ExecutorService executorService) {
        ProcessPipes processPipes = new ProcessPipes(this.env, NAMED_PIPE_HELPER, this.processConnectTimeout, "normalize", jobId, this.counter.incrementAndGet(), false, true, true, false, false);
        this.createNativeProcess(jobId, quantilesState, processPipes, bucketSpan);
        NativeNormalizerProcess normalizerProcess = new NativeNormalizerProcess(jobId, processPipes);
        try {
            normalizerProcess.start(executorService);
            return normalizerProcess;
        }
        catch (IOException | EsRejectedExecutionException e) {
            String msg = "Failed to connect to normalizer for job " + jobId;
            logger.error(msg);
            try {
                IOUtils.close((Closeable)normalizerProcess);
            }
            catch (IOException ioe) {
                logger.error("Can't close normalizer", (Throwable)ioe);
            }
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
    }

    private void createNativeProcess(String jobId, String quantilesState, ProcessPipes processPipes, Integer bucketSpan) {
        try {
            List<String> command = new NormalizerBuilder(this.env, jobId, quantilesState, bucketSpan).build();
            processPipes.addArgs(command);
            this.nativeController.startProcess(command);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("[{}] Interrupted while launching normalizer", (Object)jobId);
        }
        catch (IOException e) {
            String msg = "[" + jobId + "] Failed to launch normalizer";
            logger.error(msg);
            throw ExceptionsHelper.serverError((String)(msg + " on [" + this.nodeName + "]"), (Throwable)e);
        }
    }
}

