/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.process.StateToProcessWriterHelper;

public class StateStreamer {
    private static final Logger LOGGER = LogManager.getLogger(StateStreamer.class);
    private final Client client;
    private volatile boolean isCancelled;

    public StateStreamer(Client client) {
        this.client = Objects.requireNonNull(client);
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public void restoreStateToStream(String jobId, ModelSnapshot modelSnapshot, OutputStream restoreStream) throws IOException {
        SearchResponse stateResponse;
        ThreadContext.StoredContext ignore;
        String indexName = AnomalyDetectorsIndex.jobStateIndexPattern();
        for (String stateDocId : modelSnapshot.stateDocumentIds()) {
            if (this.isCancelled) {
                return;
            }
            LOGGER.trace("ES API CALL: get ID {} from index {}", (Object)stateDocId, (Object)indexName);
            ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");
            try {
                stateResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setSize(1).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{stateDocId})).get();
                if (stateResponse.getHits().getHits().length == 0) {
                    LOGGER.error("Expected {} documents for model state for {} snapshot {} but failed to find {}", (Object)modelSnapshot.getSnapshotDocCount(), (Object)jobId, (Object)modelSnapshot.getSnapshotId(), (Object)stateDocId);
                    break;
                }
                this.writeStateToStream(stateResponse.getHits().getAt(0).getSourceRef(), restoreStream);
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
            }
        }
        int docNum = 0;
        while (true) {
            if (this.isCancelled) {
                return;
            }
            String docId = CategorizerState.documentId((String)jobId, (int)(++docNum));
            LOGGER.trace("ES API CALL: get ID {} from index {}", (Object)docId, (Object)indexName);
            ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");
            try {
                stateResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setSize(1).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{docId})).get();
                if (stateResponse.getHits().getHits().length == 0) break;
                this.writeStateToStream(stateResponse.getHits().getAt(0).getSourceRef(), restoreStream);
                continue;
            }
            finally {
                if (ignore == null) continue;
                ignore.close();
                continue;
            }
            break;
        }
    }

    private void writeStateToStream(BytesReference source, OutputStream stream) throws IOException {
        if (this.isCancelled) {
            return;
        }
        StateToProcessWriterHelper.writeStateToStream(source, stream);
    }
}

