/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfigUpdate;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsDeleter;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class DataFrameAnalyticsConfigProvider {
    private static final Logger logger = LogManager.getLogger(DataFrameAnalyticsConfigProvider.class);
    private static final int MAX_CONFIGS_SIZE = 10000;
    private static final Map<String, String> TO_XCONTENT_PARAMS = Collections.singletonMap("for_internal_storage", "true");
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final DataFrameAnalyticsAuditor auditor;

    public DataFrameAnalyticsConfigProvider(Client client, NamedXContentRegistry xContentRegistry, DataFrameAnalyticsAuditor auditor) {
        this.client = Objects.requireNonNull(client);
        this.xContentRegistry = xContentRegistry;
        this.auditor = Objects.requireNonNull(auditor);
    }

    public void put(DataFrameAnalyticsConfig config, Map<String, String> headers, TimeValue timeout, ActionListener<DataFrameAnalyticsConfig> listener) {
        ActionListener deleteLeftOverDocsListener = ActionListener.wrap(r -> this.index(this.prepareConfigForIndex(config, headers), null, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener existsListener = ActionListener.wrap(exists -> {
            if (exists.booleanValue()) {
                listener.onFailure((Exception)ExceptionsHelper.dataFrameAnalyticsAlreadyExists((String)config.getId()));
            } else {
                this.deleteLeftOverDocs(config, timeout, (ActionListener<AcknowledgedResponse>)deleteLeftOverDocsListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.exists(config.getId(), (ActionListener<Boolean>)existsListener);
    }

    private DataFrameAnalyticsConfig prepareConfigForIndex(DataFrameAnalyticsConfig config, Map<String, String> headers) {
        return headers.isEmpty() ? config : new DataFrameAnalyticsConfig.Builder(config).setHeaders(ClientHelper.filterSecurityHeaders(headers)).build();
    }

    private void exists(String jobId, ActionListener<Boolean> listener) {
        ActionListener getListener = ActionListener.wrap(getResponse -> listener.onResponse((Object)getResponse.isExists()), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                listener.onResponse((Object)false);
            } else {
                listener.onFailure(e);
            }
        });
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), DataFrameAnalyticsConfig.documentId((String)jobId));
        getRequest.fetchSourceContext(FetchSourceContext.DO_NOT_FETCH_SOURCE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)getListener);
    }

    private void deleteLeftOverDocs(DataFrameAnalyticsConfig config, TimeValue timeout, ActionListener<AcknowledgedResponse> listener) {
        DataFrameAnalyticsDeleter deleter = new DataFrameAnalyticsDeleter(this.client, this.auditor);
        deleter.deleteAllDocuments(config, timeout, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> listener.onResponse(r), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"error deleting prior documents", (Throwable)e)));
            }
        }));
    }

    public void update(DataFrameAnalyticsConfigUpdate update, Map<String, String> headers, ClusterState clusterState, ActionListener<DataFrameAnalyticsConfig> listener) {
        String id = update.getId();
        GetRequest getRequest = new GetRequest(MlConfigIndex.indexName(), DataFrameAnalyticsConfig.documentId((String)id));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
            DataFrameAnalyticsConfig originalConfig;
            if (!getResponse.isExists()) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.missingDataFrameAnalytics((String)id)));
                return;
            }
            try (StreamInput stream = getResponse.getSourceAsBytesRef().streamInput();
                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                originalConfig = ((DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.LENIENT_PARSER.apply(parser, null)).build();
            }
            catch (IOException e) {
                listener.onFailure((Exception)new ElasticsearchParseException("Failed to parse data frame analytics configuration [" + id + "]", (Throwable)e, new Object[0]));
                return;
            }
            DataFrameAnalyticsConfigProvider.checkUpdateCanBeApplied(originalConfig, update, clusterState);
            DataFrameAnalyticsConfig.Builder updatedConfigBuilder = update.mergeWithConfig(originalConfig);
            if (!headers.isEmpty()) {
                updatedConfigBuilder.setHeaders(ClientHelper.filterSecurityHeaders((Map)headers));
            }
            DataFrameAnalyticsConfig updatedConfig = updatedConfigBuilder.build();
            this.index(updatedConfig, (GetResponse)getResponse, (ActionListener<DataFrameAnalyticsConfig>)ActionListener.wrap(indexedConfig -> {
                this.auditor.info(id, Messages.getMessage((String)"Updated analytics settings: {0}", (Object[])new Object[]{update.getUpdatedFields()}));
                listener.onResponse(indexedConfig);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void checkUpdateCanBeApplied(DataFrameAnalyticsConfig originalConfig, DataFrameAnalyticsConfigUpdate update, ClusterState clusterState) {
        PersistentTasksCustomMetadata tasks;
        String analyticsId = update.getId();
        DataFrameAnalyticsState analyticsState = MlTasks.getDataFrameAnalyticsState((String)analyticsId, (PersistentTasksCustomMetadata)(tasks = (PersistentTasksCustomMetadata)clusterState.getMetadata().custom("persistent_tasks")));
        if (DataFrameAnalyticsState.STOPPED.equals((Object)analyticsState)) {
            return;
        }
        if (update.requiresRestart(originalConfig)) {
            throw ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot update analytics [{0}] unless it''s stopped", (Object[])new Object[]{analyticsId, analyticsState}), (Object[])new Object[0]);
        }
    }

    private void index(DataFrameAnalyticsConfig config, @Nullable GetResponse getResponse, ActionListener<DataFrameAnalyticsConfig> listener) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            config.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(MlConfigIndex.indexName()).id(DataFrameAnalyticsConfig.documentId((String)config.getId())).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(builder);
            if (getResponse == null) {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            } else {
                indexRequest.opType(DocWriteRequest.OpType.INDEX).setIfSeqNo(getResponse.getSeqNo()).setIfPrimaryTerm(getResponse.getPrimaryTerm());
            }
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse((Object)config), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                    listener.onFailure((Exception)ExceptionsHelper.dataFrameAnalyticsAlreadyExists((String)config.getId()));
                } else {
                    listener.onFailure(e);
                }
            }));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise data frame analytics with id [" + config.getId() + "]", new Object[0]));
        }
    }

    public void get(String id, ActionListener<DataFrameAnalyticsConfig> listener) {
        GetDataFrameAnalyticsAction.Request request = new GetDataFrameAnalyticsAction.Request();
        request.setResourceId(id);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            List analytics = response.getResources().results();
            if (analytics.size() != 1) {
                listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Expected a single match for data frame analytics [{}] but got [{}]", (Object[])new Object[]{id, analytics.size()}));
            } else {
                listener.onResponse((Object)((DataFrameAnalyticsConfig)analytics.get(0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getMultiple(String ids, boolean allowNoMatch, ActionListener<List<DataFrameAnalyticsConfig>> listener) {
        GetDataFrameAnalyticsAction.Request request = new GetDataFrameAnalyticsAction.Request();
        request.setPageParams(new PageParams(0, 10000));
        request.setResourceId(ids);
        request.setAllowNoResources(allowNoMatch);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)response.getResources().results()), arg_0 -> listener.onFailure(arg_0)));
    }

    public void getConfigsForJobsWithTasksLeniently(final Set<String> jobsWithTask, ActionListener<List<DataFrameAnalyticsConfig>> listener) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        query.filter((QueryBuilder)QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config"));
        query.filter((QueryBuilder)QueryBuilders.termsQuery((String)DataFrameAnalyticsConfig.ID.getPreferredName(), jobsWithTask));
        SearchRequest searchRequest = new SearchRequest(new String[]{MlConfigIndex.indexName()});
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        searchRequest.source().size(10000);
        searchRequest.source().query((QueryBuilder)query);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)new ActionListener.Delegating<SearchResponse, List<DataFrameAnalyticsConfig>>(listener){

            public void onResponse(SearchResponse searchResponse) {
                SearchHit[] hits = searchResponse.getHits().getHits();
                ArrayList<DataFrameAnalyticsConfig> configs = new ArrayList<DataFrameAnalyticsConfig>(hits.length);
                for (SearchHit hit : hits) {
                    BytesReference sourceBytes = hit.getSourceRef();
                    try (StreamInput stream = sourceBytes.streamInput();
                         XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(DataFrameAnalyticsConfigProvider.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                        configs.add(((DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.LENIENT_PARSER.apply(parser, null)).build());
                    }
                    catch (IOException e) {
                        this.delegate.onFailure((Exception)e);
                    }
                }
                HashSet tasksWithoutConfigs = new HashSet(jobsWithTask);
                tasksWithoutConfigs.removeAll(configs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList()));
                if (!tasksWithoutConfigs.isEmpty()) {
                    logger.warn("Data frame analytics tasks {} have no configs", tasksWithoutConfigs);
                }
                this.delegate.onResponse(configs);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }
}

