/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;

public class TransportDeleteSnapshotLifecycleAction
extends TransportMasterNodeAction<DeleteSnapshotLifecycleAction.Request, DeleteSnapshotLifecycleAction.Response> {
    @Inject
    public TransportDeleteSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/delete", transportService, clusterService, threadPool, actionFilters, DeleteSnapshotLifecycleAction.Request::new, indexNameExpressionResolver, DeleteSnapshotLifecycleAction.Response::new, "same");
    }

    protected void masterOperation(final DeleteSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<DeleteSnapshotLifecycleAction.Response> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("delete-snapshot-lifecycle-" + request.getLifecycleId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, listener){

            protected DeleteSnapshotLifecycleAction.Response newResponse(boolean acknowledged) {
                return new DeleteSnapshotLifecycleAction.Response(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
                if (snapMeta == null) {
                    throw new ResourceNotFoundException("snapshot lifecycle policy not found: {}", new Object[]{request.getLifecycleId()});
                }
                snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getId().equals(request.getLifecycleId())).findAny().orElseThrow(() -> new ResourceNotFoundException("snapshot lifecycle policy not found: {}", new Object[]{request.getLifecycleId()}));
                Map<String, SnapshotLifecyclePolicyMetadata> newConfigs = snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> !((String)e.getKey()).equals(request.getLifecycleId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                Metadata metadata = currentState.metadata();
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)metadata).putCustom("snapshot_lifecycle", (Metadata.Custom)new SnapshotLifecycleMetadata(newConfigs, snapMeta.getOperationMode(), snapMeta.getStats().removePolicy(request.getLifecycleId())))).build();
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

