/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.HashMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleRequest;
import org.elasticsearch.xpack.core.ilm.ExplainLifecycleResponse;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleExplainResponse;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportExplainLifecycleAction
extends TransportClusterInfoAction<ExplainLifecycleRequest, ExplainLifecycleResponse> {
    private final NamedXContentRegistry xContentRegistry;
    private final IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportExplainLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/explain", transportService, clusterService, threadPool, actionFilters, ExplainLifecycleRequest::new, indexNameExpressionResolver, ExplainLifecycleResponse::new);
        this.xContentRegistry = xContentRegistry;
        this.indexLifecycleService = indexLifecycleService;
    }

    protected void doMasterOperation(Task task, ExplainLifecycleRequest request, String[] concreteIndices, ClusterState state, ActionListener<ExplainLifecycleResponse> listener) {
        HashMap<String, IndexLifecycleExplainResponse> indexResponses = new HashMap<String, IndexLifecycleExplainResponse>();
        for (String index : concreteIndices) {
            IndexLifecycleExplainResponse indexResponse;
            IndexMetadata idxMetadata = state.metadata().index(index);
            try {
                indexResponse = TransportExplainLifecycleAction.getIndexLifecycleExplainResponse(idxMetadata, request.onlyErrors(), request.onlyManaged(), this.indexLifecycleService, this.xContentRegistry);
            }
            catch (IOException e) {
                listener.onFailure((Exception)new ElasticsearchParseException("failed to parse phase definition for index [" + index + "]", (Throwable)e, new Object[0]));
                return;
            }
            if (indexResponse == null) continue;
            indexResponses.put(indexResponse.getIndex(), indexResponse);
        }
        listener.onResponse((Object)new ExplainLifecycleResponse(indexResponses));
    }

    @Nullable
    static IndexLifecycleExplainResponse getIndexLifecycleExplainResponse(IndexMetadata indexMetadata, boolean onlyErrors, boolean onlyManaged, IndexLifecycleService indexLifecycleService, NamedXContentRegistry xContentRegistry) throws IOException {
        Long originationDate;
        Settings idxSettings = indexMetadata.getSettings();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata((IndexMetadata)indexMetadata);
        String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxSettings);
        String currentPhase = lifecycleState.getPhase();
        String stepInfo = lifecycleState.getStepInfo();
        BytesArray stepInfoBytes = null;
        if (stepInfo != null) {
            stepInfoBytes = new BytesArray(stepInfo);
        }
        String indexName = indexMetadata.getIndex().getName();
        String phaseDef = lifecycleState.getPhaseDefinition();
        PhaseExecutionInfo phaseExecutionInfo = null;
        if (!Strings.isNullOrEmpty((String)phaseDef)) {
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, phaseDef);){
                phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
            }
        }
        Object indexResponse = Strings.hasLength((String)policyName) ? (!onlyErrors || "ERROR".equals(lifecycleState.getStep()) || !indexLifecycleService.policyExists(policyName) ? IndexLifecycleExplainResponse.newManagedIndexResponse((String)indexName, (String)policyName, (Long)((originationDate = idxSettings.getAsLong("index.lifecycle.origination_date", Long.valueOf(-1L))) != -1L ? originationDate : lifecycleState.getLifecycleDate()), (String)lifecycleState.getPhase(), (String)lifecycleState.getAction(), (String)lifecycleState.getStep(), (String)lifecycleState.getFailedStep(), (Boolean)lifecycleState.isAutoRetryableError(), (Integer)lifecycleState.getFailedStepRetryCount(), (Long)lifecycleState.getPhaseTime(), (Long)lifecycleState.getActionTime(), (Long)lifecycleState.getStepTime(), (String)lifecycleState.getSnapshotRepository(), (String)lifecycleState.getSnapshotName(), (String)lifecycleState.getShrinkIndexName(), (BytesReference)stepInfoBytes, (PhaseExecutionInfo)phaseExecutionInfo) : null) : (!onlyManaged && !onlyErrors ? IndexLifecycleExplainResponse.newUnmanagedIndexResponse((String)indexName) : null);
        return indexResponse;
    }
}

