/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.DocComparator;

public class ShardDocSortField
extends SortField {
    public static final String NAME = "_shard_doc";
    private final int shardRequestIndex;

    public ShardDocSortField(int shardRequestIndex, boolean reverse) {
        super(NAME, SortField.Type.LONG, reverse);
        assert (shardRequestIndex >= 0);
        this.shardRequestIndex = shardRequestIndex;
    }

    int getShardRequestIndex() {
        return this.shardRequestIndex;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        final DocComparator delegate = new DocComparator(numHits, this.getReverse(), sortPos);
        return new FieldComparator<Long>(){

            public int compare(int slot1, int slot2) {
                return delegate.compare(slot1, slot2);
            }

            public int compareValues(Long first, Long second) {
                return Long.compare(first, second);
            }

            public void setTopValue(Long value) {
                int topShardIndex = (int)(value >> 32);
                if (ShardDocSortField.this.shardRequestIndex == topShardIndex) {
                    delegate.setTopValue(Integer.valueOf(value.intValue()));
                } else if (ShardDocSortField.this.shardRequestIndex < topShardIndex) {
                    delegate.setTopValue(Integer.valueOf(Integer.MAX_VALUE));
                } else {
                    delegate.setTopValue(Integer.valueOf(-1));
                }
            }

            public Long value(int slot) {
                return (long)ShardDocSortField.this.shardRequestIndex << 32 | (long)delegate.value(slot).intValue() & 0xFFFFFFFFL;
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) {
                return delegate.getLeafComparator(context);
            }
        };
    }
}

