/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.queries.SearchAfterSortedDocQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.QueueResizingEsThreadPoolExecutor;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchContextSourcePrinter;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.query.EarlyTerminatingCollector;
import org.elasticsearch.search.query.QueryCollectorContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.TopDocsCollectorContext;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestPhase;

public class QueryPhase {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhase.class);
    public static final boolean SYS_PROP_REWRITE_SORT = Booleans.parseBoolean((String)System.getProperty("es.search.rewrite_sort", "true"));
    private final AggregationPhase aggregationPhase = new AggregationPhase();
    private final SuggestPhase suggestPhase = new SuggestPhase();
    private final RescorePhase rescorePhase = new RescorePhase();

    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            this.suggestPhase.execute(searchContext);
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        this.aggregationPhase.preProcess(searchContext);
        boolean rescore = QueryPhase.executeInternal(searchContext);
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
        if (searchContext.getProfilers() != null) {
            searchContext.queryResult().profileResults(searchContext.getProfilers().buildQueryPhaseResults());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean executeInternal(SearchContext searchContext) throws QueryPhaseExecutionException {
        Runnable timeoutRunnable;
        boolean timeoutSet;
        ContextIndexSearcher searcher = searchContext.searcher();
        IndexReader reader = searcher.getIndexReader();
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        queryResult.from(searchContext.from());
        queryResult.size(searchContext.size());
        Query query = searchContext.rewrittenQuery();
        assert (query == searcher.rewrite(query));
        ScrollContext scrollContext = searchContext.scrollContext();
        if (scrollContext != null) {
            if (scrollContext.totalHits == null) {
                assert (scrollContext.lastEmittedDoc == null);
            } else {
                ScoreDoc after = scrollContext.lastEmittedDoc;
                if (QueryPhase.returnsDocsInOrder(query, searchContext.sort())) {
                    if (after != null) {
                        query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new MinDocQuery(after.doc + 1), BooleanClause.Occur.FILTER).build();
                    }
                    searchContext.terminateAfter(searchContext.size());
                } else if (QueryPhase.canEarlyTerminate(reader, searchContext.sort()) && after != null) {
                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new SearchAfterSortedDocQuery(searchContext.sort().sort, (FieldDoc)after), BooleanClause.Occur.FILTER).build();
                }
            }
        }
        LinkedList<QueryCollectorContext> collectors = new LinkedList<QueryCollectorContext>();
        boolean hasFilterCollector = false;
        if (searchContext.terminateAfter() != 0) {
            collectors.add(QueryCollectorContext.createEarlyTerminationCollectorContext(searchContext.terminateAfter()));
            hasFilterCollector = true;
        }
        if (searchContext.parsedPostFilter() != null) {
            collectors.add(QueryCollectorContext.createFilteredCollectorContext(searcher, searchContext.parsedPostFilter().query()));
            hasFilterCollector = true;
        }
        if (!searchContext.queryCollectors().isEmpty()) {
            collectors.add(QueryCollectorContext.createMultiCollectorContext(searchContext.queryCollectors().values()));
        }
        if (searchContext.minimumScore() != null) {
            collectors.add(QueryCollectorContext.createMinScoreCollectorContext(searchContext.minimumScore().floatValue()));
            hasFilterCollector = true;
        }
        if (SYS_PROP_REWRITE_SORT) {
            QueryPhase.optimizeNumericSort(searchContext, searcher.getIndexReader());
        }
        boolean bl = timeoutSet = scrollContext == null && searchContext.timeout() != null && !searchContext.timeout().equals((Object)SearchService.NO_TIMEOUT);
        if (timeoutSet) {
            long startTime = searchContext.getRelativeTimeInMillis();
            long timeout = searchContext.timeout().millis();
            long maxTime = startTime + timeout;
            timeoutRunnable = searcher.addQueryCancellation(() -> {
                long time = searchContext.getRelativeTimeInMillis();
                if (time > maxTime) {
                    throw new TimeExceededException();
                }
            });
        } else {
            timeoutRunnable = null;
        }
        try {
            boolean shouldRescore = QueryPhase.searchWithCollector(searchContext, searcher, query, collectors, hasFilterCollector, timeoutSet);
            ExecutorService executor = searchContext.indexShard().getThreadPool().executor("search");
            if (executor instanceof QueueResizingEsThreadPoolExecutor) {
                QueueResizingEsThreadPoolExecutor rExecutor = (QueueResizingEsThreadPoolExecutor)executor;
                queryResult.nodeQueueSize(rExecutor.getCurrentQueueSize());
                queryResult.serviceTimeEWMA((long)rExecutor.getTaskExecutionEWMA());
            }
            boolean bl2 = shouldRescore;
            if (timeoutRunnable != null) {
                searcher.removeQueryCancellation(timeoutRunnable);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            try {
                if (timeoutRunnable != null) {
                    searcher.removeQueryCancellation(timeoutRunnable);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute main query", e);
            }
        }
    }

    private static boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        Collector queryCollector;
        TopDocsCollectorContext topDocsFactory = TopDocsCollectorContext.createTopDocsCollectorContext(searchContext, hasFilterCollector);
        collectors.addFirst(topDocsFactory);
        if (searchContext.getProfilers() != null) {
            InternalProfileCollector profileCollector = QueryCollectorContext.createQueryCollectorWithProfiler(collectors);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollector);
            queryCollector = profileCollector;
        } else {
            queryCollector = QueryCollectorContext.createQueryCollector(collectors);
        }
        QuerySearchResult queryResult = searchContext.queryResult();
        try {
            searcher.search(query, queryCollector);
        }
        catch (EarlyTerminatingCollector.EarlyTerminationException e) {
            queryResult.terminatedEarly(true);
        }
        catch (TimeExceededException e) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        for (QueryCollectorContext ctx : collectors) {
            ctx.postProcess(queryResult);
        }
        return topDocsFactory.shouldRescore();
    }

    private static void optimizeNumericSort(SearchContext searchContext, IndexReader reader) {
        if (searchContext.sort() == null) {
            return;
        }
        if (QueryPhase.canEarlyTerminate(reader, searchContext.sort())) {
            return;
        }
        SortField sortField = searchContext.sort().sort.getSort()[0];
        SortField.Type sortType = IndexSortConfig.getSortFieldType(sortField);
        if (sortType != SortField.Type.LONG) {
            return;
        }
        String fieldName = sortField.getField();
        if (fieldName == null) {
            return;
        }
        SearchExecutionContext searchExecutionContext = searchContext.getSearchExecutionContext();
        MappedFieldType fieldType = searchExecutionContext.getFieldType(fieldName);
        if (fieldType == null) {
            return;
        }
        if (!fieldType.isSearchable()) {
            return;
        }
        if (!fieldType.hasDocValues()) {
            return;
        }
        if (!fieldType.typeName().equals("long") && !(fieldType instanceof DateFieldMapper.DateFieldType)) {
            return;
        }
        sortField.setCanUsePoints();
    }

    private static boolean returnsDocsInOrder(Query query, SortAndFormats sf) {
        if (sf == null || Sort.RELEVANCE.equals((Object)sf.sort)) {
            return query.getClass() == ConstantScoreQuery.class || query.getClass() == MatchAllDocsQuery.class;
        }
        return Sort.INDEXORDER.equals((Object)sf.sort);
    }

    private static boolean canEarlyTerminate(IndexReader reader, SortAndFormats sortAndFormats) {
        if (sortAndFormats == null || sortAndFormats.sort == null) {
            return false;
        }
        Sort sort = sortAndFormats.sort;
        for (LeafReaderContext ctx : reader.leaves()) {
            Sort indexSort = ctx.reader().getMetaData().getSort();
            if (indexSort != null && Lucene.canEarlyTerminate(sort, indexSort)) continue;
            return false;
        }
        return true;
    }

    static class TimeExceededException
    extends RuntimeException {
        TimeExceededException() {
        }
    }
}

