/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class FieldAndFormat
implements Writeable,
ToXContentObject {
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField FORMAT_FIELD = new ParseField("format", new String[0]);
    private static final ParseField INCLUDE_UNMAPPED_FIELD = new ParseField("include_unmapped", new String[0]);
    private static final ConstructingObjectParser<FieldAndFormat, Void> PARSER = new ConstructingObjectParser("fetch_field_and_format", a -> new FieldAndFormat((String)a[0], (String)a[1], (Boolean)a[2]));
    public final String field;
    public final String format;
    public final Boolean includeUnmapped;

    public static FieldAndFormat fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token.isValue()) {
            return new FieldAndFormat(parser.text(), null);
        }
        return (FieldAndFormat)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        if (this.format != null) {
            builder.field(FORMAT_FIELD.getPreferredName(), this.format);
        }
        if (this.includeUnmapped != null) {
            builder.field(INCLUDE_UNMAPPED_FIELD.getPreferredName(), this.includeUnmapped);
        }
        builder.endObject();
        return builder;
    }

    public FieldAndFormat(String field, @Nullable String format) {
        this(field, format, null);
    }

    public FieldAndFormat(String field, @Nullable String format, @Nullable Boolean includeUnmapped) {
        this.field = Objects.requireNonNull(field);
        this.format = format;
        this.includeUnmapped = includeUnmapped;
    }

    public FieldAndFormat(StreamInput in) throws IOException {
        this.field = in.readString();
        this.format = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : null;
        this.includeUnmapped = in.getVersion().onOrAfter(Version.V_7_11_0) ? in.readOptionalBoolean() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalString(this.format);
        }
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            out.writeOptionalBoolean(this.includeUnmapped);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldAndFormat that = (FieldAndFormat)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.format, that.format) && Objects.equals(this.includeUnmapped, that.includeUnmapped);
    }

    public int hashCode() {
        int h = this.field.hashCode();
        h = 31 * h + Objects.hashCode(this.format);
        h = 31 * h + Objects.hashCode(this.includeUnmapped);
        return h;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FORMAT_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_UNMAPPED_FIELD);
    }
}

