/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DispatchingRestToXContentListener<Response extends StatusToXContentObject>
extends RestActionListener<Response> {
    private final ExecutorService executor;
    private final RestRequest restRequest;

    public DispatchingRestToXContentListener(ExecutorService executor, RestChannel channel, RestRequest restRequest) {
        super(channel);
        this.executor = executor;
        this.restRequest = restRequest;
    }

    protected ToXContent.Params getParams() {
        return this.restRequest;
    }

    @Override
    protected void processResponse(Response response) {
        this.executor.execute(ActionRunnable.wrap(this, l -> new RestBuilderListener<Response>(this.channel){

            @Override
            public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
                this.ensureOpen();
                response.toXContent(builder, DispatchingRestToXContentListener.this.getParams());
                return new BytesRestResponse(response.status(), builder);
            }
        }.onResponse(response)));
    }
}

