/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.elasticsearch.script.BooleanFieldScript;

public final class BooleanScriptDocValues
extends AbstractSortedNumericDocValues {
    private final BooleanFieldScript script;
    private int cursor;

    BooleanScriptDocValues(BooleanFieldScript script) {
        this.script = script;
    }

    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        this.cursor = 0;
        return this.script.trues() > 0 || this.script.falses() > 0;
    }

    public long nextValue() {
        return this.cursor++ < this.script.falses() ? 0L : 1L;
    }

    public int docValueCount() {
        return this.script.trues() + this.script.falses();
    }
}

