/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.dissect;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectKey;
import org.elasticsearch.dissect.DissectMatch;

public final class DissectParser {
    private static final Pattern LEADING_DELIMITER_PATTERN = Pattern.compile("^(.*?)%\\{");
    private static final Pattern KEY_DELIMITER_FIELD_PATTERN = Pattern.compile("%\\{([^}]*?)}(.+?(?=%\\{)|.*$)", 32);
    private static final EnumSet<DissectKey.Modifier> ASSOCIATE_MODIFIERS = EnumSet.of(DissectKey.Modifier.FIELD_NAME, DissectKey.Modifier.FIELD_VALUE);
    private static final EnumSet<DissectKey.Modifier> APPEND_MODIFIERS = EnumSet.of(DissectKey.Modifier.APPEND, DissectKey.Modifier.APPEND_WITH_ORDER);
    private static final Function<DissectPair, String> KEY_NAME = val -> ((DissectPair)val).getKey().getName();
    private final List<DissectPair> matchPairs;
    private final String pattern;
    private String leadingDelimiter = "";
    private final int maxMatches;
    private final int maxResults;
    private final int appendCount;
    private final int referenceCount;
    private final String appendSeparator;

    public DissectParser(String pattern, String appendSeparator) {
        this.pattern = pattern;
        this.appendSeparator = appendSeparator == null ? "" : appendSeparator;
        Matcher matcher = LEADING_DELIMITER_PATTERN.matcher(pattern);
        while (matcher.find()) {
            this.leadingDelimiter = matcher.group(1);
        }
        ArrayList<DissectPair> dissectPairs = new ArrayList<DissectPair>();
        matcher = KEY_DELIMITER_FIELD_PATTERN.matcher(pattern.substring(this.leadingDelimiter.length()));
        while (matcher.find()) {
            DissectKey key = new DissectKey(matcher.group(1));
            String delimiter = matcher.group(2);
            dissectPairs.add(new DissectPair(key, delimiter));
        }
        this.maxMatches = dissectPairs.size();
        this.maxResults = Long.valueOf(dissectPairs.stream().filter(dissectPair -> !((DissectPair)dissectPair).getKey().skip()).map(KEY_NAME).distinct().count()).intValue();
        if (this.maxMatches == 0 || this.maxResults == 0) {
            throw new DissectException.PatternParse(pattern, "Unable to find any keys or delimiters.");
        }
        Set appendKeyNames = dissectPairs.stream().filter(dissectPair -> APPEND_MODIFIERS.contains((Object)((DissectPair)dissectPair).getKey().getModifier())).map(KEY_NAME).distinct().collect(Collectors.toSet());
        if (appendKeyNames.size() > 0) {
            ArrayList<DissectPair> modifiedMatchPairs = new ArrayList<DissectPair>(dissectPairs.size());
            for (DissectPair dissectPair2 : dissectPairs) {
                if (dissectPair2.getKey().getModifier().equals((Object)DissectKey.Modifier.NONE) && appendKeyNames.contains(dissectPair2.getKey().getName())) {
                    modifiedMatchPairs.add(new DissectPair(new DissectKey(dissectPair2.getKey(), DissectKey.Modifier.APPEND), dissectPair2.getDelimiter()));
                    continue;
                }
                modifiedMatchPairs.add(dissectPair2);
            }
            dissectPairs = modifiedMatchPairs;
        }
        this.appendCount = appendKeyNames.size();
        Map<String, List<DissectPair>> referenceGroupings = dissectPairs.stream().filter(dissectPair -> ASSOCIATE_MODIFIERS.contains((Object)((DissectPair)dissectPair).getKey().getModifier())).collect(Collectors.groupingBy(KEY_NAME));
        for (Map.Entry entry : referenceGroupings.entrySet()) {
            if (((List)entry.getValue()).size() == 2) continue;
            throw new DissectException.PatternParse(pattern, "Found invalid key/reference associations: '" + ((List)entry.getValue()).stream().map(KEY_NAME).collect(Collectors.joining(",")) + "' Please ensure each '*<key>' is matched with a matching '&<key>");
        }
        this.referenceCount = referenceGroupings.size() * 2;
        this.matchPairs = Collections.unmodifiableList(dissectPairs);
    }

    public Map<String, String> parse(String inputString) {
        Map<String, String> results;
        DissectMatch dissectMatch = new DissectMatch(this.appendSeparator, this.maxMatches, this.maxResults, this.appendCount, this.referenceCount);
        Iterator<DissectPair> it = this.matchPairs.iterator();
        if (inputString != null && inputString.length() > this.leadingDelimiter.length() && this.leadingDelimiter.equals(inputString.substring(0, this.leadingDelimiter.length()))) {
            int i;
            byte[] input = inputString.getBytes(StandardCharsets.UTF_8);
            DissectPair dissectPair = it.next();
            DissectKey key = dissectPair.getKey();
            byte[] delimiter = dissectPair.getDelimiter().getBytes(StandardCharsets.UTF_8);
            int valueStart = i = this.leadingDelimiter.length();
            while (i < input.length) {
                int lookAheadMatches = 0;
                if (delimiter.length > 0 && input[i] == delimiter[0]) {
                    for (int j = 0; j < delimiter.length; ++j) {
                        if (i + j >= input.length || input[i + j] != delimiter[j]) continue;
                        ++lookAheadMatches;
                    }
                    if (lookAheadMatches == delimiter.length) {
                        byte[] value = Arrays.copyOfRange(input, valueStart, i);
                        dissectMatch.add(key, new String(value, StandardCharsets.UTF_8));
                        i += lookAheadMatches;
                        while (i < input.length) {
                            lookAheadMatches = 0;
                            for (int j = 0; j < delimiter.length; ++j) {
                                if (i + j >= input.length || input[i + j] != delimiter[j]) continue;
                                ++lookAheadMatches;
                            }
                            if (lookAheadMatches != delimiter.length) break;
                            i += lookAheadMatches;
                            if (key.skipRightPadding()) continue;
                            if (!it.hasNext()) break;
                            dissectPair = it.next();
                            key = dissectPair.getKey();
                            dissectMatch.add(key, "");
                        }
                        if (!it.hasNext()) break;
                        dissectPair = it.next();
                        key = dissectPair.getKey();
                        delimiter = dissectPair.getDelimiter().getBytes(StandardCharsets.UTF_8);
                        valueStart = i;
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
            if (!dissectMatch.fullyMatched() && delimiter.length == 0) {
                byte[] value = Arrays.copyOfRange(input, valueStart, input.length);
                String valueString = new String(value, StandardCharsets.UTF_8);
                dissectMatch.add(key, valueString);
            }
        }
        return dissectMatch.isValid(results = dissectMatch.getResults()) ? results : null;
    }

    public Map<String, String> forceParse(String inputString) {
        Map<String, String> results = this.parse(inputString);
        if (results == null) {
            throw new DissectException.FindMatch(this.pattern, inputString);
        }
        return results;
    }

    private class DissectPair {
        private final DissectKey key;
        private final String delimiter;

        private DissectPair(DissectKey key, String delimiter) {
            this.key = key;
            this.delimiter = delimiter;
        }

        private DissectKey getKey() {
            return this.key;
        }

        private String getDelimiter() {
            return this.delimiter;
        }
    }
}

