/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.SqlBinaryArithmeticOperation;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Sub
extends DateTimeArithmeticOperation
implements BinaryComparisonInversible {
    public Sub(Source source, Expression left, Expression right) {
        super(source, left, right, SqlBinaryArithmeticOperation.SUB);
    }

    protected NodeInfo<Sub> info() {
        return NodeInfo.create((Node)this, Sub::new, (Object)this.left(), (Object)this.right());
    }

    protected Sub replaceChildren(Expression newLeft, Expression newRight) {
        return new Sub(this.source(), newLeft, newRight);
    }

    @Override
    protected Expression.TypeResolution resolveWithIntervals() {
        Expression.TypeResolution resolution = super.resolveWithIntervals();
        if (resolution.unresolved()) {
            return resolution;
        }
        if (SqlDataTypes.isDateOrTimeBased(this.right().dataType()) && SqlDataTypes.isInterval(this.left().dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Cannot subtract a {}[{}] from an interval[{}]; do you mean the reverse?", (Object[])new Object[]{this.right().dataType().typeName(), this.right().source().text(), this.left().source().text()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Add::new;
    }
}

