/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeFunction;

public abstract class BinaryDateTimeDatePartFunction
extends BinaryDateTimeFunction {
    public BinaryDateTimeDatePartFunction(Source source, Expression datePart, Expression timestamp, ZoneId zoneId) {
        super(source, datePart, timestamp, zoneId);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        String datePartValue;
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.left().foldable() && (datePartValue = (String)this.left().fold()) != null && !this.resolveDateTimeField(datePartValue)) {
            List<String> similar = this.findSimilarDateTimeFields(datePartValue);
            if (similar.isEmpty()) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"first argument of [{}] must be one of {} or their aliases; found value [{}]", (Object[])new Object[]{this.sourceText(), this.validDateTimeFieldValues(), Expressions.name((Expression)this.left())}));
            }
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"Unknown value [{}] for first argument of [{}]; did you mean {}?", (Object[])new Object[]{Expressions.name((Expression)this.left()), this.sourceText(), similar}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected abstract boolean resolveDateTimeField(String var1);

    protected abstract List<String> findSimilarDateTimeFields(String var1);

    protected abstract List<String> validDateTimeFieldValues();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryDateTimeDatePartFunction that = (BinaryDateTimeDatePartFunction)((Object)o);
        return this.zoneId().equals(that.zoneId());
    }
}

