/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Predicate;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.LoggingAwareMultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.authc.service.FileServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.support.FileAttributesChecker;

public class FileTokensTool
extends LoggingAwareMultiCommand {
    public static void main(String[] args) throws Exception {
        FileTokensTool.exit((int)new FileTokensTool().main(args, Terminal.DEFAULT));
    }

    public FileTokensTool() {
        super("Manages elasticsearch service account file-tokens");
        this.subcommands.put("create", this.newCreateFileTokenCommand());
        this.subcommands.put("delete", this.newDeleteFileTokenCommand());
        this.subcommands.put("list", this.newListFileTokenCommand());
    }

    protected CreateFileTokenCommand newCreateFileTokenCommand() {
        return new CreateFileTokenCommand();
    }

    protected DeleteFileTokenCommand newDeleteFileTokenCommand() {
        return new DeleteFileTokenCommand();
    }

    protected ListFileTokenCommand newListFileTokenCommand() {
        return new ListFileTokenCommand();
    }

    static ServiceAccountToken.ServiceAccountTokenId parsePrincipalAndTokenName(List<String> arguments, Settings settings) throws UserException {
        if (arguments.isEmpty()) {
            throw new UserException(64, "Missing service-account-principal and token-name arguments");
        }
        if (arguments.size() == 1) {
            throw new UserException(64, "Missing token-name argument");
        }
        if (arguments.size() > 2) {
            throw new UserException(64, "Expected two arguments, service-account-principal and token-name, found extra: [" + Strings.collectionToCommaDelimitedString(arguments) + "]");
        }
        String principal = arguments.get(0);
        String tokenName = arguments.get(1);
        if (!ServiceAccountService.isServiceAccountPrincipal(principal)) {
            throw new UserException(67, "Unknown service account principal: [" + principal + "]. Must be one of [" + Strings.collectionToDelimitedString(ServiceAccountService.getServiceAccountPrincipals(), (String)",") + "]");
        }
        if (!Validation.isValidServiceAccountTokenName((String)tokenName)) {
            throw new UserException(70, Validation.formatInvalidServiceTokenNameErrorMessage((String)tokenName));
        }
        return new ServiceAccountToken.ServiceAccountTokenId(ServiceAccount.ServiceAccountId.fromPrincipal(principal), tokenName);
    }

    static class CreateFileTokenCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> arguments;

        CreateFileTokenCommand() {
            super("Create a file token for specified service account and token name");
            this.arguments = this.parser.nonOptions("service-account-principal token-name");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            ServiceAccountToken.ServiceAccountTokenId accountTokenId = FileTokensTool.parsePrincipalAndTokenName(this.arguments.values(options), env.settings());
            Hasher hasher = Hasher.resolve((String)((String)XPackSettings.SERVICE_TOKEN_HASHING_ALGORITHM.get(env.settings())));
            Path serviceTokensFile = FileServiceAccountTokenStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(serviceTokensFile);
            TreeMap<String, char[]> tokenHashes = new TreeMap<String, char[]>(FileServiceAccountTokenStore.parseFile(serviceTokensFile, null));
            try (ServiceAccountToken token = ServiceAccountToken.newToken(accountTokenId.getAccountId(), accountTokenId.getTokenName());){
                if (tokenHashes.containsKey(token.getQualifiedName())) {
                    throw new UserException(70, "Service token [" + token.getQualifiedName() + "] already exists");
                }
                tokenHashes.put(token.getQualifiedName(), hasher.hash(token.getSecret()));
                FileServiceAccountTokenStore.writeFile(serviceTokensFile, tokenHashes);
                terminal.println((CharSequence)("SERVICE_TOKEN " + token.getQualifiedName() + " = " + token.asBearerString()));
            }
            attributesChecker.check(terminal);
        }
    }

    static class DeleteFileTokenCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> arguments;

        DeleteFileTokenCommand() {
            super("Remove a file token for specified service account and token name");
            this.arguments = this.parser.nonOptions("service-account-principal token-name");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            ServiceAccountToken.ServiceAccountTokenId accountTokenId = FileTokensTool.parsePrincipalAndTokenName(this.arguments.values(options), env.settings());
            String qualifiedName = accountTokenId.getQualifiedName();
            Path serviceTokensFile = FileServiceAccountTokenStore.resolveFile(env);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(serviceTokensFile);
            TreeMap<String, char[]> tokenHashes = new TreeMap<String, char[]>(FileServiceAccountTokenStore.parseFile(serviceTokensFile, null));
            if (tokenHashes.remove(qualifiedName) == null) {
                throw new UserException(70, "Service token [" + qualifiedName + "] does not exist");
            }
            FileServiceAccountTokenStore.writeFile(serviceTokensFile, tokenHashes);
            attributesChecker.check(terminal);
        }
    }

    static class ListFileTokenCommand
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> arguments;

        ListFileTokenCommand() {
            super("List file tokens for the specified service account");
            this.arguments = this.parser.nonOptions("service-account-principal");
        }

        protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            List args = this.arguments.values(options);
            if (args.size() > 1) {
                throw new UserException(64, "Expected at most one argument, service-account-principal, found extra: [" + Strings.collectionToCommaDelimitedString((Iterable)args) + "]");
            }
            Predicate<String> filter = k -> true;
            if (args.size() == 1) {
                String principal = (String)args.get(0);
                if (!ServiceAccountService.isServiceAccountPrincipal(principal)) {
                    throw new UserException(67, "Unknown service account principal: [" + principal + "]. Must be one of [" + Strings.collectionToDelimitedString(ServiceAccountService.getServiceAccountPrincipals(), (String)",") + "]");
                }
                filter = filter.and(k -> k.startsWith(principal + "/"));
            }
            Path serviceTokensFile = FileServiceAccountTokenStore.resolveFile(env);
            TreeMap<String, char[]> tokenHashes = new TreeMap<String, char[]>(FileServiceAccountTokenStore.parseFile(serviceTokensFile, null));
            for (String key : tokenHashes.keySet()) {
                if (!filter.test(key)) continue;
                terminal.println((CharSequence)key);
            }
        }
    }
}

