/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email.attachment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.common.http.BasicAuth;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;

public class ReportingAttachment
implements EmailAttachmentParser.EmailAttachment {
    static final ParseField INLINE = new ParseField("inline", new String[0]);
    static final ParseField AUTH = new ParseField("auth", new String[0]);
    static final ParseField PROXY = new ParseField("proxy", new String[0]);
    static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    static final ParseField RETRIES = new ParseField("retries", new String[0]);
    static final ParseField URL = new ParseField("url", new String[0]);
    private final boolean inline;
    private final String id;
    private final BasicAuth auth;
    private final String url;
    private final TimeValue interval;
    private final Integer retries;
    private final HttpProxy proxy;

    ReportingAttachment(String id, String url, boolean inline, @Nullable TimeValue interval, @Nullable Integer retries, @Nullable BasicAuth auth, @Nullable HttpProxy proxy) {
        this.id = id;
        this.url = url;
        this.retries = retries;
        this.inline = inline;
        this.auth = auth;
        this.interval = interval;
        this.proxy = proxy;
        if (retries != null && retries < 0) {
            throw new IllegalArgumentException("Retries for attachment must be >= 0");
        }
    }

    @Override
    public String type() {
        return "reporting";
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean inline() {
        return this.inline;
    }

    public BasicAuth auth() {
        return this.auth;
    }

    public String url() {
        return this.url;
    }

    public TimeValue interval() {
        return this.interval;
    }

    public Integer retries() {
        return this.retries;
    }

    public HttpProxy proxy() {
        return this.proxy;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.id).startObject("reporting").field(URL.getPreferredName(), this.url);
        if (this.retries != null) {
            builder.field(RETRIES.getPreferredName(), this.retries);
        }
        if (this.interval != null) {
            builder.field(INTERVAL.getPreferredName(), this.interval.getStringRep());
        }
        if (this.inline) {
            builder.field(INLINE.getPreferredName(), this.inline);
        }
        if (this.auth != null) {
            builder.startObject(AUTH.getPreferredName());
            builder.field("basic", (ToXContent)this.auth, params);
            builder.endObject();
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        return builder.endObject().endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportingAttachment otherAttachment = (ReportingAttachment)o;
        return Objects.equals(this.id, otherAttachment.id) && Objects.equals(this.url, otherAttachment.url) && Objects.equals(this.interval, otherAttachment.interval) && Objects.equals(this.inline, otherAttachment.inline) && Objects.equals(this.retries, otherAttachment.retries) && Objects.equals(this.auth, otherAttachment.auth) && Objects.equals(this.proxy, otherAttachment.proxy);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.url, this.interval, this.inline, this.retries, this.auth, this.proxy);
    }
}

