/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchResponse;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestDeleteWatchAction
extends WatcherRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.DELETE, (String)"/_watcher/watch/{id}").replaces(RestRequest.Method.DELETE, URI_BASE + "/watcher/watch/{id}", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "watcher_delete_watch";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) {
        DeleteWatchRequest deleteWatchRequest = new DeleteWatchRequest(request.param("id"));
        return channel -> client.deleteWatch(deleteWatchRequest, (ActionListener)new RestBuilderListener<DeleteWatchResponse>(channel){

            public RestResponse buildResponse(DeleteWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("_id", response.getId()).field("_version", response.getVersion()).field("found", response.isFound()).endObject();
                RestStatus status = response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

