/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.policy;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AutoscalingPolicy
extends AbstractDiffable<AutoscalingPolicy>
implements Diffable<AutoscalingPolicy>,
ToXContentObject {
    public static final String NAME = "autoscaling_policy";
    public static final ParseField ROLES_FIELD = new ParseField("roles", new String[0]);
    public static final ParseField DECIDERS_FIELD = new ParseField("deciders", new String[0]);
    private static final ConstructingObjectParser<AutoscalingPolicy, String> PARSER = new ConstructingObjectParser("autoscaling_policy", false, (c, name) -> {
        List roles = (List)c[0];
        List deciders = (List)c[1];
        return new AutoscalingPolicy((String)name, Collections.unmodifiableSortedSet(new TreeSet(roles)), (SortedMap)deciders.stream().collect(Maps.toUnmodifiableSortedMap(Map.Entry::getKey, Map.Entry::getValue)));
    });
    private final String name;
    private final SortedSet<String> roles;
    private final SortedMap<String, Settings> deciders;

    public static AutoscalingPolicy parse(XContentParser parser, String name) {
        return (AutoscalingPolicy)((Object)PARSER.apply(parser, (Object)name));
    }

    public String name() {
        return this.name;
    }

    public SortedSet<String> roles() {
        return this.roles;
    }

    public SortedMap<String, Settings> deciders() {
        return this.deciders;
    }

    public AutoscalingPolicy(String name, SortedSet<String> roles, SortedMap<String, Settings> deciders) {
        this.name = Objects.requireNonNull(name);
        this.roles = Objects.requireNonNull(roles);
        this.deciders = Objects.requireNonNull(deciders);
    }

    public AutoscalingPolicy(StreamInput in) throws IOException {
        this.name = in.readString();
        this.roles = Collections.unmodifiableSortedSet(new TreeSet(in.readSet(StreamInput::readString)));
        int deciderCount = in.readInt();
        TreeMap<String, Settings> decidersMap = new TreeMap<String, Settings>();
        for (int i = 0; i < deciderCount; ++i) {
            decidersMap.put(in.readString(), Settings.readSettingsFromStream((StreamInput)in));
        }
        this.deciders = Collections.unmodifiableSortedMap(decidersMap);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.roles, StreamOutput::writeString);
        out.writeInt(this.deciders.size());
        for (Map.Entry<String, Settings> entry : this.deciders.entrySet()) {
            out.writeString(entry.getKey());
            Settings.writeSettingsToStream((Settings)entry.getValue(), (StreamOutput)out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(ROLES_FIELD.getPreferredName(), this.roles.toArray(new String[0]));
        builder.startObject(DECIDERS_FIELD.getPreferredName());
        for (Map.Entry<String, Settings> entry : this.deciders.entrySet()) {
            builder.startObject(entry.getKey());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoscalingPolicy that = (AutoscalingPolicy)((Object)o);
        return this.name.equals(that.name) && this.roles.equals(that.roles) && this.deciders.equals(that.deciders);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roles, this.deciders);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            p.nextToken();
            return new AbstractMap.SimpleEntry<String, Settings>(n, Settings.fromXContent((XContentParser)p));
        }, DECIDERS_FIELD);
    }
}

