/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.bucket.range;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public abstract class HistoBackedRangeAggregator
extends RangeAggregator {
    public static HistoBackedRangeAggregator build(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, InternalRange.Factory<?, ?> rangeFactory, RangeAggregator.Range[] ranges, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        double avgRange = (double)context.searcher().getIndexReader().maxDoc() / (double)ranges.length;
        if (HistoBackedRangeAggregator.hasOverlap((RangeAggregator.Range[])ranges)) {
            return new Overlap(name, factories, valuesSourceConfig.getValuesSource(), valuesSourceConfig.format(), rangeFactory, ranges, avgRange, keyed, context, parent, cardinality, metadata);
        }
        return new NoOverlap(name, factories, valuesSourceConfig.getValuesSource(), valuesSourceConfig.format(), rangeFactory, ranges, avgRange, keyed, context, parent, cardinality, metadata);
    }

    public HistoBackedRangeAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, RangeAggregator.Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
        if (this.subAggregators().length > 0) {
            throw new IllegalArgumentException("Range aggregation on histogram fields does not support sub-aggregations");
        }
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (!(this.valuesSource instanceof HistogramValuesSource.Histogram)) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        HistogramValuesSource.Histogram valuesSource = (HistogramValuesSource.Histogram)this.valuesSource;
        final HistogramValues values = valuesSource.getHistogramValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    double previousValue = Double.NEGATIVE_INFINITY;
                    int lo = 0;
                    while (sketch.next()) {
                        double value = sketch.value();
                        assert (previousValue <= value) : "histogram field [" + HistoBackedRangeAggregator.access$100(HistoBackedRangeAggregator.this) + "] unexpectedly out of order";
                        previousValue = value;
                        int count = sketch.count() - HistoBackedRangeAggregator.this.docCountProvider.getDocCount(doc);
                        lo = HistoBackedRangeAggregator.this.collect(sub, doc, value, bucket, lo, count);
                    }
                }
            }
        };
    }

    abstract int collect(LeafBucketCollector var1, int var2, double var3, long var5, int var7, int var8) throws IOException;

    static /* synthetic */ String access$100(HistoBackedRangeAggregator x0) {
        return x0.name;
    }

    private static class Overlap
    extends HistoBackedRangeAggregator {
        private final double[] maxTo;

        Overlap(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, RangeAggregator.Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
            this.maxTo = new double[ranges.length];
            this.maxTo[0] = ranges[0].getTo();
            for (int i = 1; i < ranges.length; ++i) {
                this.maxTo[i] = Math.max(ranges[i].getTo(), this.maxTo[i - 1]);
            }
        }

        @Override
        public int collect(LeafBucketCollector sub, int doc, double value, long owningBucketOrdinal, int lowBound, int count) throws IOException {
            int lo = lowBound;
            int hi = this.ranges.length - 1;
            int mid = lo + hi >>> 1;
            while (lo <= hi) {
                if (value < this.ranges[mid].getFrom()) {
                    hi = mid - 1;
                } else {
                    if (!(value >= this.maxTo[mid])) break;
                    lo = mid + 1;
                }
                mid = lo + hi >>> 1;
            }
            if (lo > hi) {
                return lo;
            }
            int startLo = lo;
            int startHi = mid;
            while (startLo <= startHi) {
                int startMid = startLo + startHi >>> 1;
                if (value >= this.maxTo[startMid]) {
                    startLo = startMid + 1;
                    continue;
                }
                startHi = startMid - 1;
            }
            int endLo = mid;
            int endHi = hi;
            while (endLo <= endHi) {
                int endMid = endLo + endHi >>> 1;
                if (value < this.ranges[endMid].getFrom()) {
                    endHi = endMid - 1;
                    continue;
                }
                endLo = endMid + 1;
            }
            assert (startLo == lowBound || value >= this.maxTo[startLo - 1]);
            assert (endHi == this.ranges.length - 1 || value < this.ranges[endHi + 1].getFrom());
            for (int i = startLo; i <= endHi; ++i) {
                if (!this.ranges[i].matches(value)) continue;
                long bucketOrd = this.subBucketOrdinal(owningBucketOrdinal, i);
                this.collectBucket(sub, doc, bucketOrd);
                this.incrementBucketDocCount(bucketOrd, count);
            }
            return startLo;
        }
    }

    private static class NoOverlap
    extends HistoBackedRangeAggregator {
        private NoOverlap(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, RangeAggregator.Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
        }

        @Override
        public int collect(LeafBucketCollector sub, int doc, double value, long owningBucketOrdinal, int lowBound, int count) throws IOException {
            int lo = lowBound;
            int hi = this.ranges.length - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                if (value < this.ranges[mid].getFrom()) {
                    hi = mid - 1;
                    continue;
                }
                if (value >= this.ranges[mid].getTo()) {
                    lo = mid + 1;
                    continue;
                }
                long bucketOrd = this.subBucketOrdinal(owningBucketOrdinal, mid);
                this.collectBucket(sub, doc, bucketOrd);
                this.incrementBucketDocCount(bucketOrd, count);
                return mid;
            }
            return lo;
        }
    }
}

