/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.InternalInferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.ml.inference.loadingservice.LocalModel;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportInternalInferModelAction
extends HandledTransportAction<InternalInferModelAction.Request, InternalInferModelAction.Response> {
    private final ModelLoadingService modelLoadingService;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final TrainedModelProvider trainedModelProvider;

    @Inject
    public TransportInternalInferModelAction(TransportService transportService, ActionFilters actionFilters, ModelLoadingService modelLoadingService, Client client, XPackLicenseState licenseState, TrainedModelProvider trainedModelProvider) {
        super("cluster:internal/xpack/ml/inference/infer", transportService, actionFilters, InternalInferModelAction.Request::new);
        this.modelLoadingService = modelLoadingService;
        this.client = client;
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
    }

    protected void doExecute(Task task, InternalInferModelAction.Request request, ActionListener<InternalInferModelAction.Response> listener) {
        InternalInferModelAction.Response.Builder responseBuilder = InternalInferModelAction.Response.builder();
        ActionListener getModelListener = ActionListener.wrap(model -> {
            TypedChainTaskExecutor<InferenceResults> typedChainTaskExecutor = new TypedChainTaskExecutor<InferenceResults>(this.client.threadPool().executor("same"), r -> true, ex -> true);
            request.getObjectsToInfer().forEach(stringObjectMap -> typedChainTaskExecutor.add(chainedTask -> model.infer((Map<String, Object>)stringObjectMap, request.getUpdate(), (ActionListener<InferenceResults>)chainedTask)));
            typedChainTaskExecutor.execute((ActionListener<List<InferenceResults>>)ActionListener.wrap(inferenceResultsInterfaces -> {
                model.release();
                listener.onResponse((Object)responseBuilder.setInferenceResults(inferenceResultsInterfaces).setModelId(model.getModelId()).build());
            }, e -> {
                model.release();
                listener.onFailure(e);
            }));
        }, arg_0 -> listener.onFailure(arg_0));
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            responseBuilder.setLicensed(true);
            this.modelLoadingService.getModelForPipeline(request.getModelId(), (ActionListener<LocalModel>)getModelListener);
        } else {
            this.trainedModelProvider.getTrainedModel(request.getModelId(), GetTrainedModelsAction.Includes.empty(), (ActionListener<TrainedModelConfig>)ActionListener.wrap(trainedModelConfig -> {
                responseBuilder.setLicensed(this.licenseState.isAllowedByLicense(trainedModelConfig.getLicenseLevel()));
                if (this.licenseState.isAllowedByLicense(trainedModelConfig.getLicenseLevel()) || request.isPreviouslyLicensed()) {
                    this.modelLoadingService.getModelForPipeline(request.getModelId(), (ActionListener<LocalModel>)getModelListener);
                } else {
                    listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

