/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.LockingAtomicCounter;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativePrivilegeStore {
    public static final Setting<Integer> CACHE_MAX_APPLICATIONS_SETTING = Setting.intSetting((String)"xpack.security.authz.store.privileges.cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authz.store.privileges.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Collector<Tuple<String, String>, ?, Map<String, List<String>>> TUPLES_TO_MAP = Collectors.toMap(Tuple::v1, t -> CollectionUtils.newSingletonArrayList((Object)((String)t.v2())), (a, b) -> {
        a.addAll(b);
        return a;
    });
    private static final Logger logger = LogManager.getLogger(NativePrivilegeStore.class);
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndexManager;
    private final DescriptorsAndApplicationNamesCache descriptorsAndApplicationNamesCache;

    public NativePrivilegeStore(Settings settings, Client client, SecurityIndexManager securityIndexManager, CacheInvalidatorRegistry cacheInvalidatorRegistry) {
        this.settings = settings;
        this.client = client;
        this.securityIndexManager = securityIndexManager;
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        if (ttl.getNanos() > 0L) {
            this.descriptorsAndApplicationNamesCache = new DescriptorsAndApplicationNamesCache(ttl, (Integer)CACHE_MAX_APPLICATIONS_SETTING.get(settings));
            cacheInvalidatorRegistry.registerCacheInvalidator("application_privileges", this.descriptorsAndApplicationNamesCache);
        } else {
            this.descriptorsAndApplicationNamesCache = null;
        }
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set concreteApplicationNames;
        Set applicationNamesCacheKey = NativePrivilegeStore.isEmpty(applications) || applications.contains("*") ? org.elasticsearch.core.Set.of((Object)"*") : org.elasticsearch.core.Set.copyOf(applications);
        Set set = concreteApplicationNames = this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.getConcreteApplicationNames(applicationNamesCacheKey);
        if (concreteApplicationNames != null && concreteApplicationNames.isEmpty()) {
            logger.debug("returning empty application privileges for [{}] as application names result in empty list", (Object)applicationNamesCacheKey);
            listener.onResponse(Collections.emptySet());
        } else {
            Set<ApplicationPrivilegeDescriptor> cachedDescriptors = this.cachedDescriptorsForApplicationNames(concreteApplicationNames != null ? concreteApplicationNames : applicationNamesCacheKey);
            if (cachedDescriptors != null) {
                logger.debug("All application privileges for [{}] found in cache", (Object)applicationNamesCacheKey);
                listener.onResponse(this.filterDescriptorsForPrivilegeNames(cachedDescriptors, names));
            } else {
                logger.debug("Fetching application privilege documents for: {}", (Object)applicationNamesCacheKey);
                long invalidationCount = this.descriptorsAndApplicationNamesCache == null ? -1L : this.descriptorsAndApplicationNamesCache.getInvalidationCount();
                this.innerGetPrivileges(applicationNamesCacheKey, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(fetchedDescriptors -> {
                    Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors = fetchedDescriptors.stream().collect(Collectors.groupingBy(ApplicationPrivilegeDescriptor::getApplication, Collectors.toSet()));
                    if (invalidationCount != -1L) {
                        this.cacheFetchedDescriptors(applicationNamesCacheKey, mapOfFetchedDescriptors, invalidationCount);
                    }
                    listener.onResponse(this.filterDescriptorsForPrivilegeNames((Collection<ApplicationPrivilegeDescriptor>)fetchedDescriptors, names));
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    private void innerGetPrivileges(Collection<String> applications, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        assert (applications != null && applications.size() > 0) : "Application names are required (found " + applications + ")";
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder typeQuery = QueryBuilders.termQuery((String)ApplicationPrivilegeDescriptor.Fields.TYPE.getPreferredName(), (String)"application-privilege");
                BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter(this.getApplicationNameQuery(applications));
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    logger.trace(() -> NativePrivilegeStore.lambda$innerGetPrivileges$3(applications, (QueryBuilder)query));
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> this.buildPrivilege(hit.getId(), hit.getSourceRef()));
                }
            });
        }
    }

    private QueryBuilder getApplicationNameQuery(Collection<String> applications) {
        TermsQueryBuilder termsQuery;
        if (applications.contains("*")) {
            return QueryBuilders.existsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName());
        }
        ArrayList<String> rawNames = new ArrayList<String>(applications.size());
        ArrayList<String> wildcardNames = new ArrayList<String>(applications.size());
        for (String name : applications) {
            if (name.endsWith("*")) {
                wildcardNames.add(name);
                continue;
            }
            rawNames.add(name);
        }
        assert (!rawNames.isEmpty() || !wildcardNames.isEmpty());
        TermsQueryBuilder termsQueryBuilder = termsQuery = rawNames.isEmpty() ? null : QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), rawNames);
        if (wildcardNames.isEmpty()) {
            return termsQuery;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (termsQuery != null) {
            boolQuery.should((QueryBuilder)termsQuery);
        }
        for (String wildcard : wildcardNames) {
            String prefix = wildcard.substring(0, wildcard.length() - 1);
            boolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), (String)prefix));
        }
        boolQuery.minimumShouldMatch(1);
        return boolQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ApplicationPrivilegeDescriptor buildPrivilege(String docId, BytesReference source) {
        logger.trace("Building privilege from [{}] [{}]", (Object)docId, (Object)(source == null ? "<<null>>" : source.utf8ToString()));
        if (source == null) {
            return null;
        }
        Tuple<String, String> name = NativePrivilegeStore.nameFromDocId(docId);
        try (StreamInput input = source.streamInput();){
            ApplicationPrivilegeDescriptor applicationPrivilegeDescriptor;
            block17: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)input);
                try {
                    ApplicationPrivilegeDescriptor privilege = ApplicationPrivilegeDescriptor.parse((XContentParser)parser, null, null, (boolean)true);
                    assert (privilege.getApplication().equals(name.v1())) : "Incorrect application name for privilege. Expected [" + (String)name.v1() + "] but was " + privilege.getApplication();
                    assert (privilege.getName().equals(name.v2())) : "Incorrect name for application privilege. Expected [" + (String)name.v2() + "] but was " + privilege.getName();
                    applicationPrivilegeDescriptor = privilege;
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return applicationPrivilegeDescriptor;
        }
        catch (IOException | XContentParseException e) {
            logger.error((Message)new ParameterizedMessage("cannot parse application privilege [{}]", name), e);
            return null;
        }
    }

    private Set<ApplicationPrivilegeDescriptor> cachedDescriptorsForApplicationNames(Set<String> applicationNames) {
        if (this.descriptorsAndApplicationNamesCache == null) {
            return null;
        }
        HashSet<ApplicationPrivilegeDescriptor> cachedDescriptors = new HashSet<ApplicationPrivilegeDescriptor>();
        for (String applicationName : applicationNames) {
            if (applicationName.endsWith("*")) {
                return null;
            }
            Set<ApplicationPrivilegeDescriptor> descriptors = this.descriptorsAndApplicationNamesCache.getApplicationDescriptors(applicationName);
            if (descriptors == null) {
                return null;
            }
            cachedDescriptors.addAll(descriptors);
        }
        return Collections.unmodifiableSet(cachedDescriptors);
    }

    private Collection<ApplicationPrivilegeDescriptor> filterDescriptorsForPrivilegeNames(Collection<ApplicationPrivilegeDescriptor> descriptors, Collection<String> privilegeNames) {
        if (NativePrivilegeStore.isEmpty(privilegeNames)) {
            return descriptors;
        }
        return descriptors.stream().filter(d -> privilegeNames.contains(d.getName())).collect(Collectors.toSet());
    }

    protected void cacheFetchedDescriptors(Set<String> applicationNamesCacheKey, Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors, long invalidationCount) {
        this.descriptorsAndApplicationNamesCache.putIfNoInvalidationSince(applicationNamesCacheKey, mapOfFetchedDescriptors, invalidationCount);
    }

    public void putPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                Map<String, List<String>> createdNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.CREATED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                this.clearCaches(listener, privileges.stream().map(ApplicationPrivilegeDescriptor::getApplication).collect(Collectors.toSet()), createdNames);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), privileges.size());
            for (ApplicationPrivilegeDescriptor privilege : privileges) {
                this.innerPutPrivilege(privilege, refreshPolicy, (ActionListener<IndexResponse>)groupListener);
            }
        });
    }

    private void innerPutPrivilege(ApplicationPrivilegeDescriptor privilege, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        try {
            String name = privilege.getName();
            XContentBuilder xContentBuilder = privilege.toXContent(XContentFactory.jsonBuilder(), true);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", "_doc", NativePrivilegeStore.toDocId(privilege.getApplication(), name)).setSource(xContentBuilder).setRefreshPolicy(refreshPolicy)).request()), listener, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        }
        catch (Exception e) {
            logger.warn("Failed to put privilege {} - {}", (Object)Strings.toString((ToXContent)privilege), (Object)e.toString());
            listener.onFailure(e);
        }
    }

    public void deletePrivileges(String application, Collection<String> names, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyMap());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)frozenSecurityIndex.getUnavailableReason());
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                    Map<String, List<String>> deletedNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.DELETED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                    this.clearCaches(listener, Collections.singleton(application), deletedNames);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), names.size());
                for (String name : names) {
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", "_doc", NativePrivilegeStore.toDocId(application, name)).setRefreshPolicy(refreshPolicy)).request()), (ActionListener)groupListener, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
                }
            });
        }
    }

    private <T> void clearCaches(final ActionListener<T> listener, Set<String> applicationNames, final T value) {
        ClearPrivilegesCacheRequest request = new ClearPrivilegesCacheRequest().applicationNames(applicationNames.toArray(new String[0])).clearRolesCache(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearPrivilegesCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearPrivilegesCacheResponse>(){

            public void onResponse(ClearPrivilegesCacheResponse nodes) {
                listener.onResponse(value);
            }

            public void onFailure(Exception e) {
                logger.error("unable to clear application privileges and role cache", (Throwable)e);
                listener.onFailure((Exception)new ElasticsearchException("clearing the application privileges and role cache failed. please clear the caches manually", (Throwable)e, new Object[0]));
            }
        });
    }

    private static Tuple<String, String> nameFromDocId(String docId) {
        String name = docId.substring("application-privilege".length() + 1);
        assert (name != null && name.length() > 0) : "Invalid name '" + name + "'";
        int colon = name.indexOf(58);
        assert (colon > 0) : "Invalid name '" + name + "' (missing colon)";
        return new Tuple((Object)name.substring(0, colon), (Object)name.substring(colon + 1));
    }

    private static String toDocId(String application, String name) {
        return "application-privilege_" + application + ":" + name;
    }

    private static boolean isEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty();
    }

    DescriptorsAndApplicationNamesCache getDescriptorsAndApplicationNamesCache() {
        return this.descriptorsAndApplicationNamesCache;
    }

    Cache<Set<String>, Set<String>> getApplicationNamesCache() {
        return this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.applicationNamesCache;
    }

    Cache<String, Set<ApplicationPrivilegeDescriptor>> getDescriptorsCache() {
        return this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.descriptorsCache;
    }

    long getNumInvalidation() {
        return this.descriptorsAndApplicationNamesCache.getInvalidationCount();
    }

    private static /* synthetic */ Message lambda$innerGetPrivileges$3(Collection applications, QueryBuilder query) {
        return new ParameterizedMessage("Searching for [{}] privileges with query [{}]", (Object)applications, (Object)Strings.toString((ToXContent)query));
    }

    static final class DescriptorsAndApplicationNamesCache
    implements CacheInvalidatorRegistry.CacheInvalidator {
        private final Cache<String, Set<ApplicationPrivilegeDescriptor>> descriptorsCache;
        private final Cache<Set<String>, Set<String>> applicationNamesCache;
        private final LockingAtomicCounter lockingAtomicCounter;

        DescriptorsAndApplicationNamesCache(TimeValue ttl, int cacheSize) {
            this.descriptorsCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> v.size()).setExpireAfterWrite(ttl).build();
            this.applicationNamesCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> k.size() + v.size()).setExpireAfterWrite(ttl).build();
            this.lockingAtomicCounter = new LockingAtomicCounter();
        }

        public Set<ApplicationPrivilegeDescriptor> getApplicationDescriptors(String applicationName) {
            return (Set)this.descriptorsCache.get((Object)applicationName);
        }

        public Set<String> getConcreteApplicationNames(Set<String> applicationNames) {
            return (Set)this.applicationNamesCache.get(applicationNames);
        }

        public void putIfNoInvalidationSince(Set<String> applicationNamesCacheKey, Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors, long invalidationCount) {
            this.lockingAtomicCounter.compareAndRun(invalidationCount, () -> {
                Set fetchedApplicationNames = Collections.unmodifiableSet(mapOfFetchedDescriptors.keySet());
                if (!fetchedApplicationNames.equals(applicationNamesCacheKey)) {
                    logger.debug("Caching application names query: {} = {}", (Object)applicationNamesCacheKey, fetchedApplicationNames);
                    this.applicationNamesCache.put((Object)applicationNamesCacheKey, fetchedApplicationNames);
                }
                for (Map.Entry entry : mapOfFetchedDescriptors.entrySet()) {
                    logger.debug("Caching descriptors for application: {}", entry.getKey());
                    this.descriptorsCache.put((Object)((String)entry.getKey()), (Object)((Set)entry.getValue()));
                }
            });
        }

        public long getInvalidationCount() {
            return this.lockingAtomicCounter.get();
        }

        @Override
        public void invalidate(Collection<String> updatedApplicationNames) {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating application privileges caches for: {}", updatedApplicationNames);
            Set uniqueNames = org.elasticsearch.core.Set.copyOf(updatedApplicationNames);
            this.applicationNamesCache.invalidateAll();
            updatedApplicationNames.forEach(arg_0 -> this.descriptorsCache.invalidate(arg_0));
        }

        @Override
        public void invalidateAll() {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating all application privileges caches");
            this.applicationNamesCache.invalidateAll();
            this.descriptorsCache.invalidateAll();
        }
    }
}

