/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;

public final class DeprecationRoleDescriptorConsumer
implements Consumer<Collection<RoleDescriptor>> {
    private static final String ROLE_PERMISSION_DEPRECATION_STANZA = "Role [%s] contains index privileges covering the [%s] alias but which do not cover some of the indices that it points to [%s]. Granting privileges over an alias and hence granting privileges over all the indices that the alias points to is deprecated and will be removed in a future version of Elasticsearch. Instead define permissions exclusively on index names or index name patterns.";
    private static final Logger logger = LogManager.getLogger(DeprecationRoleDescriptorConsumer.class);
    private final DeprecationLogger deprecationLogger;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Object mutex;
    private final Queue<RoleDescriptor> workQueue;
    private boolean workerBusy;
    private final Set<String> dailyRoleCache;

    public DeprecationRoleDescriptorConsumer(ClusterService clusterService, ThreadPool threadPool) {
        this(clusterService, threadPool, DeprecationLogger.getLogger(DeprecationRoleDescriptorConsumer.class));
    }

    DeprecationRoleDescriptorConsumer(ClusterService clusterService, ThreadPool threadPool, DeprecationLogger deprecationLogger) {
        this.deprecationLogger = deprecationLogger;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.mutex = new Object();
        this.workQueue = new LinkedList<RoleDescriptor>();
        this.workerBusy = false;
        this.dailyRoleCache = Collections.newSetFromMap(new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return false == eldest.getKey().startsWith(DeprecationRoleDescriptorConsumer.todayISODate());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Collection<RoleDescriptor> effectiveRoleDescriptors) {
        Object object = this.mutex;
        synchronized (object) {
            for (RoleDescriptor roleDescriptor : effectiveRoleDescriptors) {
                if (!this.dailyRoleCache.add(DeprecationRoleDescriptorConsumer.buildCacheKey(roleDescriptor))) continue;
                this.workQueue.add(roleDescriptor);
            }
            if (!this.workerBusy) {
                this.workerBusy = true;
                try {
                    this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onFailure(Exception e) {
                            logger.warn("Failed to produce role deprecation messages", (Throwable)e);
                            Object object = DeprecationRoleDescriptorConsumer.this.mutex;
                            synchronized (object) {
                                boolean hasMoreWork;
                                boolean bl = hasMoreWork = DeprecationRoleDescriptorConsumer.this.workQueue.peek() != null;
                                if (hasMoreWork) {
                                    DeprecationRoleDescriptorConsumer.this.workerBusy = true;
                                    try {
                                        DeprecationRoleDescriptorConsumer.this.threadPool.generic().execute((Runnable)((Object)this));
                                    }
                                    catch (RejectedExecutionException e1) {
                                        DeprecationRoleDescriptorConsumer.this.workerBusy = false;
                                        logger.warn("Failed to start working on role alias permisssion deprecation messages", (Throwable)e1);
                                    }
                                } else {
                                    DeprecationRoleDescriptorConsumer.this.workerBusy = false;
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void doRun() throws Exception {
                            while (true) {
                                RoleDescriptor workItem;
                                Object object = DeprecationRoleDescriptorConsumer.this.mutex;
                                synchronized (object) {
                                    workItem = (RoleDescriptor)DeprecationRoleDescriptorConsumer.this.workQueue.poll();
                                    if (workItem == null) {
                                        DeprecationRoleDescriptorConsumer.this.workerBusy = false;
                                        break;
                                    }
                                }
                                logger.trace("Begin role [" + workItem.getName() + "] check for alias permission deprecation");
                                DeprecationRoleDescriptorConsumer.this.logDeprecatedPermission(workItem);
                                logger.trace("Completed role [" + workItem.getName() + "] check for alias permission deprecation");
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    this.workerBusy = false;
                    logger.warn("Failed to start working on role alias permisssion deprecation messages", (Throwable)e);
                }
            }
        }
    }

    private void logDeprecatedPermission(RoleDescriptor roleDescriptor) {
        SortedMap aliasOrIndexMap = this.clusterService.state().metadata().getIndicesLookup();
        HashMap<String, Set> privilegesByAliasMap = new HashMap<String, Set>();
        TreeMap<String, Set> privilegesByIndexMap = new TreeMap<String, Set>();
        for (RoleDescriptor.IndicesPrivileges indexPrivilege : roleDescriptor.getIndicesPrivileges()) {
            StringMatcher matcher = StringMatcher.of(Arrays.asList(indexPrivilege.getIndices()));
            for (Map.Entry aliasOrIndex : aliasOrIndexMap.entrySet()) {
                String aliasOrIndexName = (String)aliasOrIndex.getKey();
                if (!matcher.test(aliasOrIndexName)) continue;
                if (((IndexAbstraction)aliasOrIndex.getValue()).getType() == IndexAbstraction.Type.ALIAS) {
                    Set privilegesByAlias = privilegesByAliasMap.computeIfAbsent(aliasOrIndexName, k -> new HashSet());
                    privilegesByAlias.addAll(Arrays.asList(indexPrivilege.getPrivileges()));
                    continue;
                }
                Set privilegesByIndex = privilegesByIndexMap.computeIfAbsent(aliasOrIndexName, k -> new HashSet());
                privilegesByIndex.addAll(Arrays.asList(indexPrivilege.getPrivileges()));
            }
        }
        HashMap<String, Automaton> indexAutomatonMap = new HashMap<String, Automaton>();
        for (Map.Entry privilegesByAlias : privilegesByAliasMap.entrySet()) {
            String aliasName = (String)privilegesByAlias.getKey();
            Set aliasPrivilegeNames = (Set)privilegesByAlias.getValue();
            Automaton aliasPrivilegeAutomaton = IndexPrivilege.get((Set)aliasPrivilegeNames).getAutomaton();
            TreeSet<String> inferiorIndexNames = new TreeSet<String>();
            for (Index index : ((IndexAbstraction)aliasOrIndexMap.get(aliasName)).getIndices()) {
                Set indexPrivileges = (Set)privilegesByIndexMap.get(index.getName());
                if (indexPrivileges != null) {
                    Automaton indexPrivilegeAutomaton = indexAutomatonMap.computeIfAbsent(index.getName(), i -> IndexPrivilege.get((Set)indexPrivileges).getAutomaton());
                    if (Operations.subsetOf((Automaton)indexPrivilegeAutomaton, (Automaton)aliasPrivilegeAutomaton)) continue;
                    inferiorIndexNames.add(index.getName());
                    continue;
                }
                inferiorIndexNames.add(index.getName());
            }
            if (inferiorIndexNames.isEmpty()) continue;
            String logMessage = String.format(Locale.ROOT, ROLE_PERMISSION_DEPRECATION_STANZA, roleDescriptor.getName(), aliasName, String.join((CharSequence)", ", inferiorIndexNames));
            this.deprecationLogger.warn(DeprecationCategory.SECURITY, "index_permissions_on_alias", logMessage, new Object[0]);
        }
    }

    private static String todayISODate() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.BASIC_ISO_DATE);
    }

    static String buildCacheKey(RoleDescriptor roleDescriptor) {
        return DeprecationRoleDescriptorConsumer.todayISODate() + "-" + roleDescriptor.getName();
    }
}

