/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;

public abstract class PublishableHttpResource
extends HttpResource {
    public static final String FILTER_PATH_NONE = "$NONE";
    public static final String FILTER_PATH_RESOURCE_VERSION = "*.version";
    public static final Map<String, String> NO_BODY_PARAMETERS = Collections.singletonMap("filter_path", "$NONE");
    public static final Map<String, String> RESOURCE_VERSION_PARAMETERS = Collections.singletonMap("filter_path", "*.version");
    public static final Set<Integer> GET_EXISTS = Collections.singleton(RestStatus.OK.getStatus());
    public static final Set<Integer> GET_DOES_NOT_EXIST = Collections.singleton(RestStatus.NOT_FOUND.getStatus());
    protected final Map<String, String> defaultParameters;

    protected PublishableHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, Map<String, String> baseParameters) {
        this(resourceOwnerName, masterTimeout, baseParameters, true);
    }

    protected PublishableHttpResource(String resourceOwnerName, @Nullable TimeValue masterTimeout, Map<String, String> baseParameters, boolean dirty) {
        super(resourceOwnerName, dirty);
        if (masterTimeout != null && !TimeValue.MINUS_ONE.equals((Object)masterTimeout)) {
            HashMap<String, String> parameters = new HashMap<String, String>(baseParameters.size() + 1);
            parameters.putAll(baseParameters);
            parameters.put("master_timeout", masterTimeout.toString());
            this.defaultParameters = Collections.unmodifiableMap(parameters);
        } else {
            this.defaultParameters = baseParameters;
        }
    }

    public Map<String, String> getDefaultParameters() {
        return this.defaultParameters;
    }

    @Override
    protected final void doCheckAndPublish(RestClient client, ActionListener<HttpResource.ResourcePublishResult> listener) {
        this.doCheck(client, (ActionListener<Boolean>)ActionListener.wrap(exists -> {
            if (exists.booleanValue()) {
                listener.onResponse((Object)HttpResource.ResourcePublishResult.ready());
            } else {
                this.doPublish(client, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected abstract void doCheck(RestClient var1, ActionListener<Boolean> var2);

    protected void versionCheckForResource(RestClient client, ActionListener<Boolean> listener, Logger logger, String resourceBasePath, String resourceName, String resourceType, String resourceOwnerName, String resourceOwnerType, XContent xContent, int minimumVersion) {
        CheckedFunction responseChecker = response -> this.shouldReplaceResource((Response)response, xContent, resourceName, minimumVersion);
        this.checkForResource(client, listener, logger, resourceBasePath, resourceName, resourceType, resourceOwnerName, resourceOwnerType, GET_EXISTS, GET_DOES_NOT_EXIST, (CheckedFunction<Response, Boolean, IOException>)responseChecker, (CheckedFunction<Response, Boolean, IOException>)((CheckedFunction)this::alwaysReplaceResource));
    }

    protected void checkForResource(RestClient client, final ActionListener<Boolean> listener, final Logger logger, final String resourceBasePath, final String resourceName, final String resourceType, final String resourceOwnerName, final String resourceOwnerType, final Set<Integer> exists, final Set<Integer> doesNotExist, final CheckedFunction<Response, Boolean, IOException> responseChecker, final CheckedFunction<Response, Boolean, IOException> doesNotExistResponseChecker) {
        logger.trace("checking if {} [{}] exists on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        Request request = new Request("GET", resourceBasePath + "/" + resourceName);
        this.addDefaultParameters(request);
        Set expectedResponseCodes = Sets.union(exists, doesNotExist);
        request.addParameter("ignore", expectedResponseCodes.stream().map(i -> i.toString()).collect(Collectors.joining(",")));
        client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (exists.contains(statusCode)) {
                        logger.debug("{} [{}] found on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                        listener.onResponse((Object)(false == (Boolean)responseChecker.apply((Object)response) ? 1 : 0));
                    } else if (doesNotExist.contains(statusCode)) {
                        logger.debug("{} [{}] does not exist on the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                        listener.onResponse((Object)(false == (Boolean)doesNotExistResponseChecker.apply((Object)response) ? 1 : 0));
                    } else {
                        this.onFailure((Exception)new ResponseException(response));
                    }
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("failed to parse [{}/{}] on the [{}]", new Object[]{resourceBasePath, resourceName, resourceOwnerName}), (Throwable)e);
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    Response response = ((ResponseException)exception).getResponse();
                    int statusCode = response.getStatusLine().getStatusCode();
                    logger.error(() -> new ParameterizedMessage("failed to verify {} [{}] on the [{}] {} with status code [{}]", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType, statusCode}), (Throwable)exception);
                } else {
                    logger.error(() -> new ParameterizedMessage("failed to verify {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)exception);
                }
                listener.onFailure(exception);
            }
        });
    }

    protected abstract void doPublish(RestClient var1, ActionListener<HttpResource.ResourcePublishResult> var2);

    protected void putResource(RestClient client, final ActionListener<HttpResource.ResourcePublishResult> listener, final Logger logger, final String resourceBasePath, final String resourceName, Map<String, String> parameters, Supplier<HttpEntity> body, final String resourceType, final String resourceOwnerName, final String resourceOwnerType) {
        logger.trace("uploading {} [{}] to the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        Request request = new Request("PUT", resourceBasePath + "/" + resourceName);
        this.addDefaultParameters(request);
        this.addParameters(request, parameters);
        request.setEntity(body.get());
        client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == RestStatus.OK.getStatus() || statusCode == RestStatus.CREATED.getStatus()) {
                    logger.debug("{} [{}] uploaded to the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                    listener.onResponse((Object)HttpResource.ResourcePublishResult.ready());
                } else {
                    this.onFailure(new RuntimeException("[" + resourceBasePath + "/" + resourceName + "] responded with [" + statusCode + "]"));
                }
            }

            public void onFailure(Exception exception) {
                logger.error(() -> new ParameterizedMessage("failed to upload {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)exception);
                listener.onFailure(exception);
            }
        });
    }

    protected void deleteResource(RestClient client, final ActionListener<Boolean> listener, final Logger logger, final String resourceBasePath, final String resourceName, final String resourceType, final String resourceOwnerName, final String resourceOwnerType) {
        logger.trace("deleting {} [{}] from the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
        Request request = new Request("DELETE", resourceBasePath + "/" + resourceName);
        this.addDefaultParameters(request);
        if (!this.defaultParameters.containsKey("ignore")) {
            request.addParameter("ignore", Integer.toString(RestStatus.NOT_FOUND.getStatus()));
        }
        client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == RestStatus.OK.getStatus() || statusCode == RestStatus.NOT_FOUND.getStatus()) {
                    logger.debug("{} [{}] deleted from the [{}] {}", (Object)resourceType, (Object)resourceName, (Object)resourceOwnerName, (Object)resourceOwnerType);
                    listener.onResponse((Object)true);
                } else {
                    this.onFailure(new RuntimeException("[" + resourceBasePath + "/" + resourceName + "] responded with [" + statusCode + "]"));
                }
            }

            public void onFailure(Exception exception) {
                logger.error(() -> new ParameterizedMessage("failed to delete {} [{}] on the [{}] {}", new Object[]{resourceType, resourceName, resourceOwnerName, resourceOwnerType}), (Throwable)exception);
                listener.onFailure(exception);
            }
        });
    }

    protected boolean shouldReplaceResource(Response response, XContent xContent, String resourceName, int minimumVersion) throws IOException {
        Map resources = XContentHelper.convertToMap((XContent)xContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        if (!resources.isEmpty()) {
            Object version;
            Map resource = (Map)resources.get(resourceName);
            Object v0 = version = resource != null ? resource.get("version") : null;
            if (version instanceof Number) {
                return ((Number)version).intValue() < minimumVersion;
            }
        }
        return true;
    }

    protected boolean alwaysReplaceResource(Response response) {
        return true;
    }

    private void addDefaultParameters(Request request) {
        this.addParameters(request, this.defaultParameters);
    }

    private void addParameters(Request request, Map<String, String> parameters) {
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            request.addParameter(param.getKey(), param.getValue());
        }
    }
}

