/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RootObjectMapper
extends ObjectMapper {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RootObjectMapper.class);
    static final String TOXCONTENT_SKIP_RUNTIME = "skip_runtime";
    private Explicit<DateFormatter[]> dynamicDateTimeFormatters;
    private Explicit<Boolean> dateDetection;
    private Explicit<Boolean> numericDetection;
    private Explicit<DynamicTemplate[]> dynamicTemplates;
    private Map<String, RuntimeField> runtimeFields;

    public void fixRedundantIncludes() {
        RootObjectMapper.fixRedundantIncludes(this, true);
    }

    private static void fixRedundantIncludes(ObjectMapper objectMapper, boolean parentIncluded) {
        for (Mapper mapper : objectMapper) {
            boolean includedInRoot;
            if (!(mapper instanceof NestedObjectMapper)) continue;
            NestedObjectMapper child = (NestedObjectMapper)mapper;
            boolean isNested = child.isNested();
            boolean includeInRootViaParent = parentIncluded && isNested && child.isIncludeInParent();
            boolean bl = includedInRoot = isNested && child.isIncludeInRoot();
            if (includeInRootViaParent && includedInRoot) {
                child.setIncludeInParent(true);
                child.setIncludeInRoot(false);
            }
            RootObjectMapper.fixRedundantIncludes(child, includeInRootViaParent || includedInRoot);
        }
    }

    RootObjectMapper(String name, Explicit<Boolean> enabled, ObjectMapper.Dynamic dynamic, Map<String, Mapper> mappers, Map<String, RuntimeField> runtimeFields, Explicit<DateFormatter[]> dynamicDateTimeFormatters, Explicit<DynamicTemplate[]> dynamicTemplates, Explicit<Boolean> dateDetection, Explicit<Boolean> numericDetection) {
        super(name, name, enabled, dynamic, mappers);
        this.runtimeFields = runtimeFields;
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    @Override
    protected ObjectMapper clone() {
        ObjectMapper clone = super.clone();
        ((RootObjectMapper)clone).runtimeFields = new HashMap<String, RuntimeField>(this.runtimeFields);
        return clone;
    }

    @Override
    RootObjectMapper copyAndReset() {
        RootObjectMapper copy = (RootObjectMapper)super.copyAndReset();
        copy.dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        copy.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        copy.dateDetection = new Explicit<Boolean>(true, false);
        copy.numericDetection = new Explicit<Boolean>(false, false);
        copy.runtimeFields.clear();
        return copy;
    }

    public boolean dateDetection() {
        return this.dateDetection.value();
    }

    public boolean numericDetection() {
        return this.numericDetection.value();
    }

    public DateFormatter[] dynamicDateTimeFormatters() {
        return this.dynamicDateTimeFormatters.value();
    }

    public DynamicTemplate[] dynamicTemplates() {
        return this.dynamicTemplates.value();
    }

    Collection<RuntimeField> runtimeFields() {
        return this.runtimeFields.values();
    }

    RuntimeField getRuntimeField(String name) {
        return this.runtimeFields.get(name);
    }

    @Override
    public RootObjectMapper merge(Mapper mergeWith, MapperService.MergeReason reason) {
        return (RootObjectMapper)super.merge(mergeWith, reason);
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith, MapperService.MergeReason reason) {
        super.doMerge(mergeWith, reason);
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (mergeWithObject.numericDetection.explicit()) {
            this.numericDetection = mergeWithObject.numericDetection;
        }
        if (mergeWithObject.dateDetection.explicit()) {
            this.dateDetection = mergeWithObject.dateDetection;
        }
        if (mergeWithObject.dynamicDateTimeFormatters.explicit()) {
            this.dynamicDateTimeFormatters = mergeWithObject.dynamicDateTimeFormatters;
        }
        if (mergeWithObject.dynamicTemplates.explicit()) {
            if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                LinkedHashMap<String, DynamicTemplate> templatesByKey = new LinkedHashMap<String, DynamicTemplate>();
                for (DynamicTemplate template : this.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                for (DynamicTemplate template : mergeWithObject.dynamicTemplates.value()) {
                    templatesByKey.put(template.name(), template);
                }
                DynamicTemplate[] mergedTemplates = templatesByKey.values().toArray(new DynamicTemplate[0]);
                this.dynamicTemplates = new Explicit<DynamicTemplate[]>(mergedTemplates, true);
            } else {
                this.dynamicTemplates = mergeWithObject.dynamicTemplates;
            }
        }
        assert (this.runtimeFields != mergeWithObject.runtimeFields);
        for (Map.Entry<String, RuntimeField> runtimeField : mergeWithObject.runtimeFields.entrySet()) {
            if (runtimeField.getValue() == null) {
                this.runtimeFields.remove(runtimeField.getKey());
                continue;
            }
            this.runtimeFields.put(runtimeField.getKey(), runtimeField.getValue());
        }
    }

    void addRuntimeFields(Collection<RuntimeField> runtimeFields) {
        for (RuntimeField runtimeField : runtimeFields) {
            this.runtimeFields.put(runtimeField.name(), runtimeField);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (this.dynamicDateTimeFormatters.explicit() || includeDefaults) {
            builder.startArray("dynamic_date_formats");
            for (DateFormatter dateTimeFormatter : this.dynamicDateTimeFormatters.value()) {
                builder.value(dateTimeFormatter.pattern());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates.explicit() || includeDefaults) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates.value()) {
                builder.startObject();
                builder.field(dynamicTemplate.name(), (ToXContent)dynamicTemplate);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.dateDetection.explicit() || includeDefaults) {
            builder.field("date_detection", this.dateDetection.value());
        }
        if (this.numericDetection.explicit() || includeDefaults) {
            builder.field("numeric_detection", this.numericDetection.value());
        }
        if (this.runtimeFields.size() > 0 && !params.paramAsBoolean(TOXCONTENT_SKIP_RUNTIME, false)) {
            builder.startObject("runtime");
            List sortedRuntimeFields = this.runtimeFields.values().stream().sorted(Comparator.comparing(RuntimeField::name)).collect(Collectors.toList());
            for (RuntimeField fieldType : sortedRuntimeFields) {
                fieldType.toXContent(builder, params);
            }
            builder.endObject();
        }
    }

    private static void validateDynamicTemplate(MappingParserContext parserContext, DynamicTemplate template) {
        if (RootObjectMapper.containsSnippet(template.getMapping(), "{name}")) {
            return;
        }
        DynamicTemplate.XContentFieldType[] types = template.getXContentFieldTypes();
        Exception lastError = null;
        for (DynamicTemplate.XContentFieldType fieldType : types) {
            String dynamicType = template.isRuntimeMapping() ? fieldType.defaultRuntimeMappingType() : fieldType.defaultMappingType();
            String mappingType = template.mappingType(dynamicType);
            try {
                if (template.isRuntimeMapping()) {
                    RuntimeField.Parser parser = parserContext.runtimeFieldParser(mappingType);
                    if (parser == null) {
                        throw new IllegalArgumentException("No runtime field found for type [" + mappingType + "]");
                    }
                    RootObjectMapper.validate(template, dynamicType, (name, mapping) -> parser.parse((String)name, (Map<String, Object>)mapping, parserContext));
                } else {
                    Mapper.TypeParser typeParser = parserContext.typeParser(mappingType);
                    if (typeParser == null) {
                        throw new IllegalArgumentException("No mapper found for type [" + mappingType + "]");
                    }
                    RootObjectMapper.validate(template, dynamicType, (name, mapping) -> typeParser.parse((String)name, (Map<String, Object>)mapping, parserContext).build(MapperBuilderContext.ROOT));
                }
                lastError = null;
                break;
            }
            catch (Exception e) {
                lastError = e;
            }
        }
        boolean shouldEmitDeprecationWarning = parserContext.indexVersionCreated().onOrAfter(Version.V_7_7_0);
        if (lastError != null && shouldEmitDeprecationWarning) {
            String format = "dynamic template [%s] has invalid content [%s], attempted to validate it with the following match_mapping_type: %s, caused by [%s]";
            String message = String.format(Locale.ROOT, format, template.getName(), Strings.toString((ToXContent)template), Arrays.toString((Object[])types), lastError.getMessage());
            DEPRECATION_LOGGER.critical(DeprecationCategory.TEMPLATES, "invalid_dynamic_template", message, new Object[0]);
        }
    }

    private static void validate(DynamicTemplate template, String dynamicType, BiConsumer<String, Map<String, Object>> mappingConsumer) {
        String templateName = "__dynamic__" + template.name();
        Map<String, Object> fieldTypeConfig = template.mappingForName(templateName, dynamicType);
        mappingConsumer.accept(templateName, fieldTypeConfig);
        fieldTypeConfig.remove("type");
        if (!fieldTypeConfig.isEmpty()) {
            throw new IllegalArgumentException("Unknown mapping attributes [" + fieldTypeConfig + "]");
        }
    }

    private static boolean containsSnippet(Map<?, ?> map, String snippet) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            if (key.contains(snippet)) {
                return true;
            }
            Object value = entry.getValue();
            if (!RootObjectMapper.containsSnippet(value, snippet)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(List<?> list, String snippet) {
        for (Object value : list) {
            if (!RootObjectMapper.containsSnippet(value, snippet)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSnippet(Object value, String snippet) {
        if (value instanceof Map) {
            return RootObjectMapper.containsSnippet((Map)value, snippet);
        }
        if (value instanceof List) {
            return RootObjectMapper.containsSnippet((List)value, snippet);
        }
        if (value instanceof String) {
            return ((String)value).contains(snippet);
        }
        return false;
    }

    public static class Defaults {
        public static final DateFormatter[] DYNAMIC_DATE_TIME_FORMATTERS = new DateFormatter[]{DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER, DateFormatter.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis")};
        public static final boolean DATE_DETECTION = true;
        public static final boolean NUMERIC_DETECTION = false;
    }

    static final class TypeParser
    extends ObjectMapper.TypeParser {
        TypeParser() {
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !this.processField(builder, fieldName, fieldNode, parserContext)) continue;
                iterator.remove();
            }
            return builder;
        }

        private boolean processField(Builder builder, String fieldName, Object fieldNode, MappingParserContext parserContext) {
            if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
                if (fieldNode instanceof List) {
                    ArrayList<DateFormatter> formatters = new ArrayList<DateFormatter>();
                    for (Object formatter : (List)fieldNode) {
                        if (formatter.toString().startsWith("epoch_")) {
                            throw new MapperParsingException("Epoch [" + formatter + "] is not supported as dynamic date format");
                        }
                        formatters.add(TypeParsers.parseDateTimeFormatter(formatter));
                    }
                    builder.dynamicDateTimeFormatter(formatters);
                } else if ("none".equals(fieldNode.toString())) {
                    builder.dynamicDateTimeFormatter(Collections.emptyList());
                } else {
                    builder.dynamicDateTimeFormatter(Collections.singleton(TypeParsers.parseDateTimeFormatter(fieldNode)));
                }
                return true;
            }
            if (fieldName.equals("dynamic_templates")) {
                if (!(fieldNode instanceof List)) {
                    throw new MapperParsingException("Dynamic template syntax error. An array of named objects is expected.");
                }
                List tmplNodes = (List)fieldNode;
                ArrayList<DynamicTemplate> templates = new ArrayList<DynamicTemplate>();
                for (Object tmplNode : tmplNodes) {
                    Map templateParams;
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    String templateName = (String)entry.getKey();
                    DynamicTemplate template = DynamicTemplate.parse(templateName, templateParams = (Map)entry.getValue(), parserContext.indexVersionCreated());
                    if (template == null) continue;
                    RootObjectMapper.validateDynamicTemplate(parserContext, template);
                    templates.add(template);
                }
                builder.dynamicTemplates(templates);
                return true;
            }
            if (fieldName.equals("date_detection")) {
                builder.dateDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "date_detection"), true);
                return true;
            }
            if (fieldName.equals("numeric_detection")) {
                builder.numericDetection = new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(fieldNode, "numeric_detection"), true);
                return true;
            }
            if (fieldName.equals("runtime")) {
                if (fieldNode instanceof Map) {
                    Map<String, RuntimeField> fields = RuntimeField.parseRuntimeFields((Map)fieldNode, parserContext, true);
                    builder.setRuntime(fields);
                    return true;
                }
                throw new ElasticsearchParseException("runtime must be a map type", new Object[0]);
            }
            return false;
        }
    }

    public static class Builder
    extends ObjectMapper.Builder {
        protected Explicit<DynamicTemplate[]> dynamicTemplates = new Explicit<DynamicTemplate[]>(new DynamicTemplate[0], false);
        protected Explicit<DateFormatter[]> dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(Defaults.DYNAMIC_DATE_TIME_FORMATTERS, false);
        protected Explicit<Boolean> dateDetection = new Explicit<Boolean>(true, false);
        protected Explicit<Boolean> numericDetection = new Explicit<Boolean>(false, false);
        protected Map<String, RuntimeField> runtimeFields;

        public Builder(String name) {
            super(name);
        }

        public Builder dynamicDateTimeFormatter(Collection<DateFormatter> dateTimeFormatters) {
            this.dynamicDateTimeFormatters = new Explicit<DateFormatter[]>(dateTimeFormatters.toArray(new DateFormatter[0]), true);
            return this;
        }

        public Builder dynamicTemplates(Collection<DynamicTemplate> templates) {
            this.dynamicTemplates = new Explicit<DynamicTemplate[]>(templates.toArray(new DynamicTemplate[0]), true);
            return this;
        }

        @Override
        public Builder add(Mapper.Builder builder) {
            super.add(builder);
            return this;
        }

        public Builder setRuntime(Map<String, RuntimeField> runtimeFields) {
            this.runtimeFields = runtimeFields;
            return this;
        }

        @Override
        public RootObjectMapper build(MapperBuilderContext context) {
            return new RootObjectMapper(this.name, this.enabled, this.dynamic, this.buildMappers(true, context), this.runtimeFields == null ? Collections.emptyMap() : this.runtimeFields, this.dynamicDateTimeFormatters, this.dynamicTemplates, this.dateDetection, this.numericDetection);
        }
    }
}

