/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.MetadataCachingIndexInput;

public class CachedBlobContainerIndexInput
extends MetadataCachingIndexInput {
    public static final IOContext CACHE_WARMING_CONTEXT = new IOContext();
    private static final Logger logger = LogManager.getLogger(CachedBlobContainerIndexInput.class);

    public CachedBlobContainerIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, int rangeSize, int recoveryRangeSize) {
        this(name, directory, fileInfo, context, stats, 0L, 0L, fileInfo.length(), new MetadataCachingIndexInput.CacheFileReference(directory, fileInfo.physicalName(), fileInfo.length()), rangeSize, recoveryRangeSize, directory.getBlobCacheByteRange(name, fileInfo.length()), ByteRange.EMPTY);
        stats.incrementOpenCount();
    }

    private CachedBlobContainerIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, MetadataCachingIndexInput.CacheFileReference cacheFileReference, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(logger, name, directory, fileInfo, context, stats, offset, compoundFileOffset, length, cacheFileReference, defaultRangeSize, recoveryRangeSize, headerBlobCacheByteRange, footerBlobCacheByteRange);
    }

    @Override
    protected long getDefaultRangeSize() {
        return this.context != CACHE_WARMING_CONTEXT ? (long)(this.directory.isRecoveryFinalized() ? this.defaultRangeSize : this.recoveryRangeSize) : this.fileInfo.partSize().getBytes();
    }

    @Override
    protected void readWithoutBlobCache(ByteBuffer b) throws Exception {
        this.ensureContext(ctx -> ctx != CACHE_WARMING_CONTEXT);
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        CacheFile cacheFile = this.cacheFileReference.get();
        ByteRange startRangeToWrite = this.computeRange(position);
        ByteRange endRangeToWrite = this.computeRange(position + (long)length - 1L);
        assert (startRangeToWrite.end() <= endRangeToWrite.end()) : startRangeToWrite + " vs " + endRangeToWrite;
        ByteRange rangeToWrite = startRangeToWrite.minEnvelope(endRangeToWrite);
        ByteRange rangeToRead = ByteRange.of(position, position + (long)length);
        assert (rangeToRead.isSubRangeOf(rangeToWrite)) : rangeToRead + " vs " + rangeToWrite;
        assert (rangeToRead.length() == (long)b.remaining()) : b.remaining() + " vs " + rangeToRead;
        Future<Integer> populateCacheFuture = cacheFile.populateAndRead(rangeToWrite, rangeToRead, channel -> this.readCacheFile(channel, position, b), this::writeCacheFile, this.directory.cacheFetchAsyncExecutor());
        int bytesRead = populateCacheFuture.get();
        assert (bytesRead == length) : bytesRead + " vs " + length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple<Long, Long> prefetchPart(int part, Supplier<Boolean> isCancelled) throws IOException {
        this.ensureContext(ctx -> ctx == CACHE_WARMING_CONTEXT);
        if (part >= this.fileInfo.numberOfParts()) {
            throw new IllegalArgumentException("Unexpected part number [" + part + "]");
        }
        if (isCancelled.get().booleanValue()) {
            return Tuple.tuple((Object)0L, (Object)0L);
        }
        ByteRange partRange = this.computeRange(IntStream.range(0, part).mapToLong(arg_0 -> ((BlobStoreIndexShardSnapshot.FileInfo)this.fileInfo).partBytes(arg_0)).sum());
        assert (this.assertRangeIsAlignedWithPart(partRange));
        try {
            CacheFile cacheFile = this.cacheFileReference.get();
            ByteRange range = cacheFile.getAbsentRangeWithin(partRange);
            if (range == null) {
                logger.trace("prefetchPart: part [{}] bytes [{}-{}] is already fully available for cache file [{}]", (Object)part, (Object)partRange.start(), (Object)partRange.end(), (Object)this.cacheFileReference);
                return Tuple.tuple((Object)cacheFile.getInitialLength(), (Object)0L);
            }
            logger.trace("prefetchPart: prewarming part [{}] bytes [{}-{}] by fetching bytes [{}-{}] for cache file [{}]", (Object)part, (Object)partRange.start(), (Object)partRange.end(), (Object)range.start(), (Object)range.end(), (Object)this.cacheFileReference);
            byte[] copyBuffer = new byte[SearchableSnapshotsUtils.toIntBytes(Math.min((long)COPY_BUFFER_SIZE, range.length()))];
            long totalBytesRead = 0L;
            AtomicLong totalBytesWritten = new AtomicLong();
            long startTimeNanos = this.stats.currentTimeNanos();
            try (InputStream input = this.openInputStreamFromBlobStore(range.start(), range.length());){
                int bytesRead;
                for (long remainingBytes = range.length(); remainingBytes > 0L; totalBytesRead += (long)bytesRead, remainingBytes -= (long)bytesRead) {
                    ByteRange rangeToWrite;
                    assert (totalBytesRead + remainingBytes == range.length());
                    if (isCancelled.get().booleanValue()) {
                        Tuple tuple = Tuple.tuple((Object)cacheFile.getInitialLength(), (Object)totalBytesRead);
                        return tuple;
                    }
                    bytesRead = CachedBlobContainerIndexInput.readSafe(input, copyBuffer, range.start(), range.end(), remainingBytes, this.cacheFileReference);
                    long readStart = range.start() + totalBytesRead;
                    ByteRange rangeToRead = rangeToWrite = ByteRange.of(readStart, readStart + (long)bytesRead);
                    cacheFile.populateAndRead(rangeToWrite, rangeToRead, channel -> bytesRead, (channel, start, end, progressUpdater) -> {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(copyBuffer, SearchableSnapshotsUtils.toIntBytes(start - readStart), SearchableSnapshotsUtils.toIntBytes(end - start));
                        int writtenBytes = CachedBlobContainerIndexInput.positionalWrite(channel, start, byteBuffer);
                        logger.trace("prefetchPart: writing range [{}-{}] of file [{}], [{}] bytes written", (Object)start, (Object)end, (Object)this.fileInfo.physicalName(), (Object)writtenBytes);
                        totalBytesWritten.addAndGet(writtenBytes);
                        progressUpdater.accept(start + (long)writtenBytes);
                    }, this.directory.cacheFetchAsyncExecutor()).get();
                }
                long endTimeNanos = this.stats.currentTimeNanos();
                this.stats.addCachedBytesWritten(totalBytesWritten.get(), endTimeNanos - startTimeNanos);
            }
            if ($assertionsDisabled) return Tuple.tuple((Object)cacheFile.getInitialLength(), (Object)range.length());
            if (totalBytesRead == range.length()) return Tuple.tuple((Object)cacheFile.getInitialLength(), (Object)range.length());
            throw new AssertionError();
        }
        catch (Exception e) {
            throw new IOException("Failed to prefetch file part in cache", e);
        }
    }

    private boolean assertRangeIsAlignedWithPart(ByteRange range) {
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            long length = this.fileInfo.length();
            assert (range.start() == 0L) : "start of range [" + range.start() + "] is not aligned with zero";
            assert (range.end() == length) : "end of range [" + range.end() + "] is not aligned with file length [" + length + ']';
        } else {
            long length = this.fileInfo.partSize().getBytes();
            assert (range.start() % length == 0L) : "start of range [" + range.start() + "] is not aligned with part start";
            assert (range.end() % length == 0L || range.end() == this.fileInfo.length()) : "end of range [" + range.end() + "] is not aligned with part end or with file length";
        }
        return true;
    }

    @Override
    public CachedBlobContainerIndexInput clone() {
        return (CachedBlobContainerIndexInput)super.clone();
    }

    public IndexInput slice(String sliceName, long sliceOffset, long sliceLength) {
        ByteRange sliceFooterByteRange;
        ByteRange sliceHeaderByteRange;
        long sliceCompoundFileOffset;
        boolean sliceCompoundFile;
        if (sliceOffset < 0L || sliceLength < 0L || sliceOffset + sliceLength > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceName + " out of bounds: offset=" + sliceOffset + ",length=" + sliceLength + ",fileLength=" + this.length() + ": " + (Object)((Object)this));
        }
        boolean bl = sliceCompoundFile = IndexFileNames.matchesExtension((String)this.name, (String)"cfs") && IndexFileNames.getExtension((String)sliceName) != null && this.compoundFileOffset == 0L && !this.isClone;
        if (sliceCompoundFile) {
            sliceCompoundFileOffset = this.offset + sliceOffset;
            sliceHeaderByteRange = this.directory.getBlobCacheByteRange(sliceName, sliceLength).shift(sliceCompoundFileOffset);
            sliceFooterByteRange = !sliceHeaderByteRange.isEmpty() && sliceHeaderByteRange.length() < sliceLength ? ByteRange.of(sliceLength - (long)CodecUtil.footerLength(), sliceLength).shift(sliceCompoundFileOffset) : ByteRange.EMPTY;
        } else {
            sliceCompoundFileOffset = this.compoundFileOffset;
            sliceHeaderByteRange = ByteRange.EMPTY;
            sliceFooterByteRange = ByteRange.EMPTY;
        }
        CachedBlobContainerIndexInput slice = new CachedBlobContainerIndexInput(sliceName, this.directory, this.fileInfo, this.context, this.stats, this.offset + sliceOffset, sliceCompoundFileOffset, sliceLength, this.cacheFileReference, this.defaultRangeSize, this.recoveryRangeSize, sliceHeaderByteRange, sliceFooterByteRange);
        slice.isClone = true;
        return slice;
    }

    @Override
    public String toString() {
        CacheFile cacheFile = this.cacheFileReference.cacheFile.get();
        return super.toString() + "[cache file=" + (cacheFile != null ? String.join((CharSequence)"/", this.directory.getShardId().getIndex().getUUID(), String.valueOf(this.directory.getShardId().getId()), "snapshot_cache", this.directory.getSnapshotId().getUUID(), cacheFile.getFile().getFileName().toString()) : null) + ']';
    }
}

