/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class ServiceAccountInfo
implements Writeable,
ToXContent {
    private final String principal;
    private final RoleDescriptor roleDescriptor;

    public ServiceAccountInfo(String principal, RoleDescriptor roleDescriptor) {
        this.principal = Objects.requireNonNull(principal, "service account principal cannot be null");
        this.roleDescriptor = Objects.requireNonNull(roleDescriptor, "service account descriptor cannot be null");
    }

    public ServiceAccountInfo(StreamInput in) throws IOException {
        this.principal = in.readString();
        this.roleDescriptor = new RoleDescriptor(in);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public RoleDescriptor getRoleDescriptor() {
        return this.roleDescriptor;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        this.roleDescriptor.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.principal);
        builder.field("role_descriptor");
        this.roleDescriptor.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "ServiceAccountInfo{principal='" + this.principal + '\'' + ", roleDescriptor=" + this.roleDescriptor + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountInfo that = (ServiceAccountInfo)o;
        return this.principal.equals(that.principal) && this.roleDescriptor.equals(that.roleDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.roleDescriptor);
    }
}

