/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteTrainedModelAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteTrainedModelAction INSTANCE = new DeleteTrainedModelAction();
    public static final String NAME = "cluster:admin/xpack/ml/inference/delete";

    private DeleteTrainedModelAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentFragment {
        private String id;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
        }

        public Request() {
        }

        public Request(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, TrainedModelConfig.MODEL_ID);
        }

        public String getId() {
            return this.id;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.id);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.id, request.id);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

