/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CheckNotDataStreamWriteIndexStep
extends ClusterStateWaitStep {
    public static final String NAME = "check-not-write-index";
    private static final Logger logger = LogManager.getLogger(CheckNotDataStreamWriteIndexStep.class);

    CheckNotDataStreamWriteIndexStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        Metadata metadata = clusterState.metadata();
        IndexMetadata indexMetadata = metadata.index(index);
        String indexName = index.getName();
        if (indexMetadata == null) {
            String errorMessage = String.format(Locale.ROOT, "[%s] lifecycle action for index [%s] executed but index no longer exists", this.getKey().getAction(), indexName);
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new Info(errorMessage));
        }
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(indexName);
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + indexName + "] was not found";
        IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            assert (dataStream.getWriteIndex() != null) : dataStream.getName() + " has no write index";
            if (dataStream.getWriteIndex().equals((Object)index)) {
                String errorMessage = String.format(Locale.ROOT, "index [%s] is the write index for data stream [%s], pausing ILM execution of lifecycle [%s] until this index is no longer the write index for the data stream via manual or automated rollover", indexName, dataStream.getName(), policyName);
                logger.debug(errorMessage);
                return new ClusterStateWaitStep.Result(false, new Info(errorMessage));
            }
        }
        return new ClusterStateWaitStep.Result(true, null);
    }

    static final class Info
    implements ToXContentObject {
        private final String message;
        static final ParseField MESSAGE = new ParseField("message", new String[0]);

        Info(String message) {
            this.message = message;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.endObject();
            return builder;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.message, info.message);
        }

        public int hashCode() {
            return Objects.hash(this.message);
        }
    }
}

