/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.SimpleVectorTileFormatter;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.xpack.spatial.GeometryFormatterExtension;
import org.elasticsearch.xpack.vectortile.feature.FeatureFactory;

public class SpatialGeometryFormatterExtension
implements GeometryFormatterExtension {
    public List<GeoFormatterFactory.FormatterFactory<Geometry>> getGeometryFormatterFactories() {
        return Collections.singletonList(new GeoFormatterFactory.FormatterFactory<Geometry>(){

            public String getName() {
                return "mvt";
            }

            public Function<String, Function<List<Geometry>, List<Object>>> getFormatterBuilder() {
                return params -> {
                    int[] parsed = SimpleVectorTileFormatter.parse((String)params);
                    FeatureFactory featureFactory = new FeatureFactory(parsed[0], parsed[1], parsed[2], parsed[3]);
                    return geometries -> {
                        GeometryCollection geometry = geometries.size() == 1 ? (Geometry)geometries.get(0) : new GeometryCollection(geometries);
                        return new ArrayList<byte[]>(featureFactory.getFeatures((Geometry)geometry));
                    };
                };
            }
        });
    }
}

