/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SharedGroupFactory;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;

public class SecurityNetty4ServerTransport
extends SecurityNetty4Transport {
    @Nullable
    private final IPFilter authenticator;

    public SecurityNetty4ServerTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter authenticator, SSLService sslService, SharedGroupFactory sharedGroupFactory) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sslService, sharedGroupFactory);
        this.authenticator = authenticator;
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    protected ChannelHandler getNoSslChannelInitializer(String name) {
        return new IPFilterServerChannelInitializer(name);
    }

    protected Netty4Transport.ServerChannelInitializer getSslChannelInitializer(String name, SSLConfiguration configuration) {
        return new SecurityServerChannelInitializer(name, configuration);
    }

    private void maybeAddIPFilter(Channel ch, String name) {
        if (this.authenticator != null) {
            ch.pipeline().addFirst("ipfilter", (ChannelHandler)new IpFilterRemoteAddressFilter(this.authenticator, name));
        }
    }

    public class IPFilterServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        IPFilterServerChannelInitializer(String name) {
            super((Netty4Transport)SecurityNetty4ServerTransport.this, name);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SecurityNetty4ServerTransport.this.maybeAddIPFilter(ch, this.name);
        }
    }

    public class SecurityServerChannelInitializer
    extends SecurityNetty4Transport.SslChannelInitializer {
        SecurityServerChannelInitializer(String name, SSLConfiguration configuration) {
            super((SecurityNetty4Transport)SecurityNetty4ServerTransport.this, name, configuration);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SecurityNetty4ServerTransport.this.maybeAddIPFilter(ch, this.name);
        }
    }
}

