/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.TransportSingleItemBulkWriteAction;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.List;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.CreateServiceAccountTokenResponse;
import org.elasticsearch.xpack.core.security.action.service.DeleteServiceAccountTokenRequest;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.service.CachingServiceAccountTokenStore;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class IndexServiceAccountTokenStore
extends CachingServiceAccountTokenStore {
    private static final Logger logger = LogManager.getLogger(IndexServiceAccountTokenStore.class);
    static final String SERVICE_ACCOUNT_TOKEN_DOC_TYPE = "service_account_token";
    private final Clock clock;
    private final Client client;
    private final SecurityIndexManager securityIndex;
    private final ClusterService clusterService;
    private final Hasher hasher;

    public IndexServiceAccountTokenStore(Settings settings, ThreadPool threadPool, Clock clock, Client client, SecurityIndexManager securityIndex, ClusterService clusterService, CacheInvalidatorRegistry cacheInvalidatorRegistry) {
        super(settings, threadPool);
        this.clock = clock;
        this.client = client;
        this.securityIndex = securityIndex;
        this.clusterService = clusterService;
        cacheInvalidatorRegistry.registerCacheInvalidator("index_service_account_token", this);
        this.hasher = Hasher.resolve((String)((String)XPackSettings.SERVICE_TOKEN_HASHING_ALGORITHM.get(settings)));
    }

    @Override
    void doAuthenticate(ServiceAccountToken token, ActionListener<ServiceAccountTokenStore.StoreAuthenticationResult> listener) {
        GetRequest getRequest = (GetRequest)this.client.prepareGet(".security", "_doc", this.docIdForToken(token.getQualifiedName())).setFetchSource(true).request();
        this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.isExists()) {
                String tokenHash = (String)response.getSource().get("password");
                assert (tokenHash != null) : "service account token hash cannot be null";
                listener.onResponse((Object)new ServiceAccountTokenStore.StoreAuthenticationResult(Hasher.verifyHash((SecureString)token.getSecret(), (char[])tokenHash.toCharArray()), this.getTokenSource()));
            } else {
                logger.trace("service account token [{}] not found in index", (Object)token.getQualifiedName());
                listener.onResponse((Object)new ServiceAccountTokenStore.StoreAuthenticationResult(false, this.getTokenSource()));
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
    }

    @Override
    public TokenInfo.TokenSource getTokenSource() {
        return TokenInfo.TokenSource.INDEX;
    }

    void createToken(Authentication authentication, CreateServiceAccountTokenRequest request, ActionListener<CreateServiceAccountTokenResponse> listener) {
        ServiceAccount.ServiceAccountId accountId = new ServiceAccount.ServiceAccountId(request.getNamespace(), request.getServiceName());
        if (!ServiceAccountService.isServiceAccountPrincipal(accountId.asPrincipal())) {
            listener.onFailure((Exception)new IllegalArgumentException("service account [" + accountId + "] does not exist"));
            return;
        }
        ServiceAccountToken token = ServiceAccountToken.newToken(accountId, request.getTokenName());
        try (XContentBuilder builder = this.newDocument(authentication, token);){
            IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", "_doc").setId(this.docIdForToken(token.getQualifiedName())).setSource(builder).setOpType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(request.getRefreshPolicy())).request();
            BulkRequest bulkRequest = TransportSingleItemBulkWriteAction.toSingleItemBulkRequest((ReplicatedWriteRequest)indexRequest);
            this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)BulkAction.INSTANCE, (ActionRequest)bulkRequest, (ActionListener)TransportSingleItemBulkWriteAction.wrapBulkResponse((ActionListener)ActionListener.wrap(response -> {
                assert (DocWriteResponse.Result.CREATED == response.getResult()) : "an successful response of an OpType.CREATE request must have result of CREATED";
                listener.onResponse((Object)CreateServiceAccountTokenResponse.created((String)token.getTokenName(), (SecureString)token.asBearerString()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)))));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    void findTokensFor(ServiceAccount.ServiceAccountId accountId, ActionListener<Collection<TokenInfo>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)List.of());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason()));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                Supplier contextSupplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)SERVICE_ACCOUNT_TOKEN_DOC_TYPE)).must((QueryBuilder)QueryBuilders.termQuery((String)"username", (String)accountId.asPrincipal()));
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.getSettings())).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(false).request();
                    request.indicesOptions().ignoreUnavailable();
                    logger.trace("Searching tokens for service account [{}]", (Object)accountId);
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(contextSupplier, listener), hit -> this.extractTokenInfo(hit.getId(), accountId));
                }
            });
        }
    }

    void deleteToken(DeleteServiceAccountTokenRequest request, ActionListener<Boolean> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason()));
        } else {
            ServiceAccount.ServiceAccountId accountId = new ServiceAccount.ServiceAccountId(request.getNamespace(), request.getServiceName());
            if (!ServiceAccountService.isServiceAccountPrincipal(accountId.asPrincipal())) {
                listener.onResponse((Object)false);
                return;
            }
            ServiceAccountToken.ServiceAccountTokenId accountTokenId = new ServiceAccountToken.ServiceAccountTokenId(accountId, request.getTokenName());
            String qualifiedTokenName = accountTokenId.getQualifiedName();
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                DeleteRequest deleteRequest = (DeleteRequest)this.client.prepareDelete(".security", "_doc", this.docIdForToken(qualifiedTokenName)).request();
                deleteRequest.setRefreshPolicy(request.getRefreshPolicy());
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)DeleteAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)ActionListener.wrap(deleteResponse -> {
                    ClearSecurityCacheRequest clearSecurityCacheRequest = new ClearSecurityCacheRequest().cacheName("index_service_account_token").keys(new String[]{qualifiedTokenName});
                    ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearSecurityCacheAction.INSTANCE, (ActionRequest)clearSecurityCacheRequest, (ActionListener)ActionListener.wrap(clearSecurityCacheResponse -> listener.onResponse((Object)(deleteResponse.getResult() == DocWriteResponse.Result.DELETED ? 1 : 0)), e -> {
                        ParameterizedMessage message = new ParameterizedMessage("clearing the cache for service token [{}] failed. please clear the cache manually", (Object)qualifiedTokenName);
                        logger.error((Message)message, (Throwable)e);
                        listener.onFailure((Exception)((Object)new ElasticsearchException(message.getFormattedMessage(), (Throwable)e, new Object[0])));
                    }));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            });
        }
    }

    private String docIdForToken(String qualifiedTokenName) {
        return "service_account_token-" + qualifiedTokenName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XContentBuilder newDocument(Authentication authentication, ServiceAccountToken serviceAccountToken) throws IOException {
        Version version = this.clusterService.state().nodes().getMinNodeVersion();
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().field("doc_type", SERVICE_ACCOUNT_TOKEN_DOC_TYPE).field("version", version.id).field("username", serviceAccountToken.getAccountId().asPrincipal()).field("name", serviceAccountToken.getTokenName()).field("creation_time", this.clock.instant().toEpochMilli()).field("enabled", true).startObject("creator").field("principal", authentication.getUser().principal()).field("full_name", authentication.getUser().fullName()).field("email", authentication.getUser().email()).field("metadata", authentication.getUser().metadata()).field("realm", authentication.getSourceRealm().getName()).field("realm_type", authentication.getSourceRealm().getType()).endObject();
        byte[] utf8Bytes = null;
        char[] tokenHash = this.hasher.hash(serviceAccountToken.getSecret());
        try {
            utf8Bytes = CharArrays.toUtf8Bytes((char[])tokenHash);
            builder.field("password").utf8Value(utf8Bytes, 0, utf8Bytes.length);
        }
        finally {
            if (utf8Bytes != null) {
                Arrays.fill(utf8Bytes, (byte)0);
            }
            Arrays.fill(tokenHash, '\u0000');
        }
        builder.endObject();
        return builder;
    }

    private TokenInfo extractTokenInfo(String docId, ServiceAccount.ServiceAccountId accountId) {
        int prefixLength = SERVICE_ACCOUNT_TOKEN_DOC_TYPE.length() + accountId.asPrincipal().length() + 2;
        return TokenInfo.indexToken((String)Strings.substring((String)docId, (int)prefixLength, (int)docId.length()));
    }
}

